package ab.issue.model.values;

import android.arch.persistence.room.TypeConverter;

import com.google.common.base.MoreObjects;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressWarnings("Guava")
public class PersonName {

    @TypeConverter
    public static String toJson(PersonName personName) {
        return new Gson().toJson(personName);
    }

    @TypeConverter
    public static PersonName fromJson(String json) {
        TypeToken<PersonName> typeToken = new TypeToken<PersonName>() {
        };
        return new Gson().fromJson(json, typeToken.getType());
    }

    public static PersonName create(@Nullable FirebaseVisionBarcode.PersonName personName) {
        PersonName name = new PersonName();
        if (personName != null) {
            name.firstName = personName.getFirst();
            name.lastName = personName.getLast();
            name.middleName = personName.getMiddle();
            name.prefix = personName.getPrefix();
            name.suffix = personName.getSuffix();
            name.name = personName.getFormattedName();
        }
        return name;
    }

    public static PersonName create(String name) {
        PersonName personName = new PersonName();
        personName.name = name;
        return personName;
    }

    private String prefix;
    private String firstName;
    private String middleName;
    private String lastName;
    private String suffix;
    private String name;

    @Nonnull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("prefix", prefix)
                .add("firstName", firstName)
                .add("middleName", middleName)
                .add("lastName", lastName)
                .add("suffix", suffix)
                .add("name", name)
                .omitNullValues()
                .toString();
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
