package ab.issue.model.values;

import android.arch.persistence.room.TypeConverter;
import android.content.Context;
import android.support.annotation.Nullable;

import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;

import app.issue.commons.java.ValueEnum;

public enum PhoneType implements ValueEnum {
    WORK(0),
    HOME(1),
    FAX(2),
    MOBILE(3);

    private final int value;

    PhoneType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return value;
    }

    public String getName(Context context) {
        throw new IllegalStateException("Illegal type=" + this);
    }

    @Nullable
    static PhoneType fromFirebasePhoneType(int phoneType) {
        switch (phoneType) {
            case FirebaseVisionBarcode.Phone.TYPE_FAX:
                return FAX;
            case FirebaseVisionBarcode.Phone.TYPE_HOME:
                return HOME;
            case FirebaseVisionBarcode.Phone.TYPE_MOBILE:
                return MOBILE;
            case FirebaseVisionBarcode.Phone.TYPE_WORK:
                return WORK;
            case FirebaseVisionBarcode.Phone.TYPE_UNKNOWN:
            default:
                return null;
        }
    }

    @TypeConverter
    public static int toValue(PhoneType phoneType) {
        return phoneType == null ? -1 : phoneType.getValue();
    }

    @TypeConverter
    public static PhoneType fromValue(int value) {
        return value == -1 ? null : ValueEnum.fromValue(PhoneType.values(), value);
    }
}
