package ab.issue.model.values;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.support.annotation.Nullable;

import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.zxing.client.result.SMSParsedResult;

import java.util.List;
import java.util.Locale;

import ab.issue.db.BarcodeDatabase;
import ab.issue.db.DbConstants;
import ab.issue.model.Barcode;
import androidx.navigation.NavController;

import static com.google.common.base.Optional.fromNullable;

@SuppressWarnings("Guava")
@Entity(
        tableName = DbConstants.SMS_TABLE_NAME,
        foreignKeys = @ForeignKey(
                entity = Barcode.class,
                parentColumns = DbConstants.COLUMN_NAME_BARCODE_ID,
                childColumns = DbConstants.COLUMN_NAME_SMS_BARCODE_ID,
                onUpdate = ForeignKey.CASCADE,
                onDelete = ForeignKey.CASCADE
        ),
        indices = @Index(value = DbConstants.COLUMN_NAME_SMS_BARCODE_ID, unique = true)
)
public class SmsBarcodeFormat implements BarcodeFormatValue {

    public static SmsBarcodeFormat create(@Nullable FirebaseVisionBarcode.Sms sms) {
        SmsBarcodeFormat smsValue = new SmsBarcodeFormat();
        if (sms != null) {
            smsValue.setBody(sms.getMessage());
            smsValue.setNumber(sms.getPhoneNumber());
        }
        return smsValue;
    }

    public static SmsBarcodeFormat create(SMSParsedResult smsParsedResult) {
        SmsBarcodeFormat smsValue = new SmsBarcodeFormat();
        if (smsParsedResult != null) {
//            smsValue.setNumber(ArrayUtils.getFirstItem(smsParsedResult.getNumbers()));
            smsValue.setBody(smsParsedResult.getBody());
        }
        return smsValue;
    }

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = DbConstants.COLUMN_NAME_SMS_ID)
    private long id;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_SMS_BARCODE_ID)
    private long barcodeId;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_SMS_NUMBER)
    private String number;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_SMS_BODY)
    private String body;

    @Override
    public String getName(Context context) {
        return null;
    }

    @Override
    public BarcodeFormatValueType getType() {
        return BarcodeFormatValueType.SMS;
    }

    @Override
    public String encode() {
        return String.format(Locale.ENGLISH, "SMSTO:%s:%s",
                fromNullable(getNumber()).or(""),
                fromNullable(body).or(""));
    }

    @Override
    public int getIcon() {
        return 0;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setBarcodeId(long barcodeId) {
        this.barcodeId = barcodeId;
    }

    @Override
    public void save(BarcodeDatabase barcodeDatabase) {
        barcodeDatabase.smsDao().insert(this);
    }

    @Override
    public void create(NavController navController) {
    }

    @Override
    public List<Barcode> search(BarcodeDatabase barcodeDatabase, String query) {
        return barcodeDatabase.smsDao().findTextInBarcodeFormatValues(query);
    }

    public long getId() {
        return id;
    }

    public long getBarcodeId() {
        return barcodeId;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return body;
    }
}

