package ab.issue.model.values;

import android.content.Context;
import android.support.annotation.NonNull;

import com.google.common.base.MoreObjects;

import java.util.ArrayList;
import java.util.List;

import ab.issue.db.BarcodeDatabase;
import ab.issue.model.Barcode;
import androidx.navigation.NavController;

public class TextBarcodeFormat implements BarcodeFormatValue {

    private static final String NAME = "QR Code";

    private String text;

    public TextBarcodeFormat() {
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatValueType getType() {
        return BarcodeFormatValueType.TEXT;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String encode() {
        return text;
    }

    @Override
    public int getIcon() {
        return 0;
    }

    @Override
    public void save(BarcodeDatabase barcodeDatabase) {
    }

    @Override
    public void setBarcodeId(long id) {
    }

    @Override
    public void create(NavController navController) {
//        Bundle bundle = new CreateTextBarcodeFragmentArgs.Builder(BarcodeFormatType.QR_CODE.getValue()).build().toBundle();
//        navController.navigate(R.id.action_create_text_barcode, bundle);
    }

    @NonNull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("text", text)
                .add("type", getType())
                .omitNullValues()
                .toString();
    }

    @Override
    public List<Barcode> search(BarcodeDatabase barcodeDatabase, String query) {
        return new ArrayList<>();
    }
}
