package ab.issue.model.values;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import ab.issue.db.BarcodeDatabase;
import ab.issue.model.Barcode;
import androidx.navigation.NavController;

public class UnknownBarcodeFormatValue implements BarcodeFormatValue {

    public static final UnknownBarcodeFormatValue INSTANCE = new UnknownBarcodeFormatValue();

    @Override
    public BarcodeFormatValueType getType() {
        return BarcodeFormatValueType.UNKNOWN;
    }

    @Override
    public String encode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName(Context context) {
        return context.getString(android.R.string.unknownName);
    }

    @Override
    public int getIcon() {
        return 0;
    }

    @Override
    public void save(BarcodeDatabase barcodeDatabase) {
    }

    @Override
    public void setBarcodeId(long id) {

    }

    @Override
    public void create(NavController navController) {

    }

    @Override
    public List<Barcode> search(BarcodeDatabase barcodeDatabase, String query) {
        return new ArrayList<>();
    }
}
