package ab.issue.model.values;

import android.arch.persistence.room.ColumnInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.common.base.MoreObjects;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.zxing.client.result.URIParsedResult;

import ab.issue.db.DbConstants;

@SuppressWarnings("Guava")
public class UrlBookmark {

    public static UrlBookmark create(@Nullable FirebaseVisionBarcode.UrlBookmark urlBookmark) {
        UrlBookmark bookmark = new UrlBookmark();
        if (urlBookmark != null) {
            bookmark.title = urlBookmark.getTitle();
            bookmark.url = urlBookmark.getUrl();
        }
        return bookmark;
    }

    public static UrlBookmark create(URIParsedResult uriParsedResult) {
        UrlBookmark result = new UrlBookmark();
        if (uriParsedResult != null) {
            result.url = uriParsedResult.getURI();
            result.title = uriParsedResult.getTitle();
        }
        return result;
    }

    @ColumnInfo(name = DbConstants.COLUMN_NAME_URL_TITLE)
    private String title;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_URL)
    private String url;

    @NonNull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("title", title)
                .add("url", url)
                .toString();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public String getUrl() {
        return url;
    }
}
