package ab.issue.model.values;

import android.arch.persistence.room.TypeConverter;
import android.support.annotation.Nullable;

import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.zxing.client.result.WifiParsedResult;

import app.issue.commons.java.ValueEnum;

public enum WifiEncryptionType implements ValueEnum {
    OPEN(0, "nopass"),
    WEP(1, "WEP"),
    WPA(2, "WPA");

    private final int value;
    private final String encodingName;

    WifiEncryptionType(int value, String encodingName) {
        this.value = value;
        this.encodingName = encodingName;
    }

    public int getValue() {
        return value;
    }

    public String getEncodingName() {
        return encodingName;
    }

    @Nullable
    public static WifiEncryptionType from(FirebaseVisionBarcode.WiFi wiFi) {
        if (wiFi == null) {
            return null;
        }
        switch (wiFi.getEncryptionType()) {
            case FirebaseVisionBarcode.WiFi.TYPE_OPEN:
                return OPEN;
            case FirebaseVisionBarcode.WiFi.TYPE_WEP:
                return WEP;
            case FirebaseVisionBarcode.WiFi.TYPE_WPA:
                return WPA;
            default:
                return null;
        }
    }

    @Nullable
    public static WifiEncryptionType from(WifiParsedResult wifiParsedResult) {
        if (wifiParsedResult == null) {
            return null;
        }
        for (WifiEncryptionType wifiEncryptionType : WifiEncryptionType.values()) {
        }
        return null;
    }

    @TypeConverter
    public static WifiEncryptionType toWifiEncryptionType(int value) {
        return ValueEnum.fromValue(WifiEncryptionType.values(), value);
    }

    @TypeConverter
    public static int toInt(WifiEncryptionType wifiEncryptionType) {
        return wifiEncryptionType.getValue();
    }
}
