package ab.issue.utils;

/**
 * Created by Ankit Batra on 31/03/17.
 */

public final class ArrayUtils {

    public static final String[] EMPTY_ARRAY_STRING = new String[0];

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static String combine(Object[] array, String on) {
        if (isEmpty(array)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; i++) {
            builder.append(array[i].toString());
            if (i < array.length - 1) {
                builder.append(on);
            }
        }
        return builder.toString();
    }

    public static String combine(Object[] array, char c) {
        return ArrayUtils.combine(array, String.valueOf(c));
    }

    public static <T> T[] returnEmptyIfNull(T[] array, T[] empty) {
        return array == null ? empty : array;
    }

    private ArrayUtils() {
    }
}
