package ab.issue.utils;

import android.content.Context;
import android.graphics.Point;
import android.view.Surface;
import android.view.WindowManager;

import timber.log.Timber;

public final class SystemServiceUtils {

    private SystemServiceUtils() {
    }

    public static int getWindowRotationDegrees(Context context) {
        int windowRotation = getWindowRotation(context);
        switch (windowRotation) {
            case Surface.ROTATION_0:
                return 0;
            case Surface.ROTATION_90:
                return 90;
            case Surface.ROTATION_180:
                return 180;
            case Surface.ROTATION_270:
                return 270;
            default:
                Timber.e("Bad rotation value=%d", windowRotation);
        }
        /*
         * Portrait mode!
         */
        return 90;
    }

    public static Point getWindowSize(Context context) {
        WindowManager windowManager = getSystemService(context, Context.WINDOW_SERVICE);
        Point outSize = new Point();
        windowManager.getDefaultDisplay().getSize(outSize);
        return outSize;
    }

    private static int getWindowRotation(Context context) {
        WindowManager windowManager = getSystemService(context, Context.WINDOW_SERVICE);
        return windowManager.getDefaultDisplay().getRotation();

    }

    @SuppressWarnings("unchecked")
    private static <T> T getSystemService(Context context, String name) {
        return (T) context.getSystemService(name);
    }
}
