package app.issue.commons;

import android.app.NotificationManager;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiManager;
import android.preference.PreferenceManager;
import android.view.WindowManager;

import javax.inject.Singleton;

import app.issue.commons.viewmodel.ViewModelModule;
import dagger.Module;
import dagger.Provides;

/**
 * @author abatra
 */
@Module(includes = {
        ViewModelModule.class
})
public class CommonsModule {

    private final String authority;

    public CommonsModule(String authority) {
        this.authority = authority;
    }

    @Provides
    @Singleton
    ClipboardManager clipboardManager(Context context) {
        return (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
    }

    @Provides
    @Singleton
    WindowManager windowManager(Context context) {
        return (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    }

    @Provides
    @Singleton
    WifiManager wifiManager(Context context) {
        Context applicationContext = context.getApplicationContext();
        return (WifiManager) applicationContext.getSystemService(Context.WIFI_SERVICE);
    }

    @Provides
    @Singleton
    NotificationManager notificationManager(Context context) {
        return (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
    }

    @Singleton
    @Provides
    SharedPreferences sharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences(context);
    }

}
