package app.issue.commons.java;

import android.support.annotation.NonNull;

/**
 * @author abatra
 */

public class CompositeVisitor<T> implements Visitor<T> {

    private final Visitor<T>[] visitors;

    public CompositeVisitor(Visitor<T>... visitors) {
        this.visitors = visitors;
    }

    @Override
    public void visit(@NonNull T item) {
        for (Visitor<T> visitor : visitors) {
            visitor.visit(item);
        }
    }
}
