package app.issue.commons.java;

import com.google.common.collect.FluentIterable;

@SuppressWarnings("Guava")
public interface ValueEnum {

    int getValue();

    static <T extends ValueEnum> T fromValue(T[] enumeration, int value) {
        return FluentIterable.from(enumeration)
                .firstMatch(input -> input.getValue() == value)
                .orNull();
    }
}
