package app.issue.commons.sqlite.room;

import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Update;

import java.util.Collection;

public interface IDao<T> {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(T row);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long[] insert(Collection<T> rows);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    int update(T row);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    int update(Collection<T> rows);

    @Delete
    void delete(T row);

    @Delete
    void delete(T[] rows);

    @Delete
    void delete(Collection<T> rows);
}
