package app.issue.commons.binding;

import android.widget.ImageView;

import com.bumptech.glide.RequestManager;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;

import app.issue.commons.model.Image;

import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.MockitoAnnotations.initMocks;

public class ImageVariableTest {

    @Mock
    private RequestManager mockedRequestManager;

    @Mock
    private Image mockedImage;

    @Mock
    private ImageView mockedImageView;

    @Before
    public void setup() {
        initMocks(this);
    }

    @Test
    public void setImageWithRequestManager() {
        ImageVariable imageVariable = new ImageVariable(mockedImage);
        imageVariable.setRequestManager(mockedRequestManager);
        imageVariable.set(mockedImageView);

        verify(mockedImage, times(1)).load(mockedRequestManager, mockedImageView);
        verify(mockedImage, times(0)).set(mockedImageView);
    }

    @Test
    public void setImageWithoutRequestManager() {
        ImageVariable imageVariable = new ImageVariable(mockedImage);
        imageVariable.set(mockedImageView);

        verify(mockedImage, times(0)).load(mockedRequestManager, mockedImageView);
        verify(mockedImage, times(1)).set(mockedImageView);
    }
}
