package app.issue.commons.binding;

import android.support.v7.widget.AppCompatImageView;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;

import app.issue.commons.model.Image;

import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.MockitoAnnotations.initMocks;

public class ImageViewBindingAdaptersTest {

    @Mock
    private AppCompatImageView mockedAppCompatImageView;

    @Mock
    private Image mockedImage;

    @Mock
    private ImageVariable mockedImageVariable;

    @Before
    public void setup() {
        initMocks(this);
    }

    @Test
    public void settingVectorIconRes() {
        ImageViewBindingAdapters.vectorIconRes(mockedAppCompatImageView, 0);
        verify(mockedAppCompatImageView, times(1)).setImageResource(0);
    }

    @Test
    public void setImage() {
        ImageViewBindingAdapters.setImage(mockedAppCompatImageView, mockedImage);
        verify(mockedImage, times(1)).set(mockedAppCompatImageView);
    }

    @Test
    public void setImageVariable() {
        ImageViewBindingAdapters.setImageVariable(mockedAppCompatImageView, mockedImageVariable);
        verify(mockedImageVariable, times(1)).set(mockedAppCompatImageView);
    }
}
