package dominando.android.livros

import android.os.Bundle
import android.view.*
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProviders
import dominando.android.livros.databinding.FragmentBookDetailsBinding
import dominando.android.presentation.BookDetailsViewModel
import dominando.android.presentation.BookVmFactory
import dominando.android.presentation.binding.Book
import org.parceler.Parcels

class BookDetailsFragment : BaseFragment() {
    private val viewModel: BookDetailsViewModel by lazy {
        ViewModelProviders.of(this,
                BookVmFactory(requireActivity().application)
        ).get(BookDetailsViewModel::class.java)
    }

    private lateinit var binding: FragmentBookDetailsBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setHasOptionsMenu(true)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        binding = DataBindingUtil.inflate(
                inflater, R.layout.fragment_book_details, container, false
        )
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val book = Parcels.unwrap<Book>(arguments?.getParcelable("book"))
        if (book != null) {
            binding.book = book
        }
    }

    override fun init() {
        binding.book?.let { book ->
            viewModel.getBook(book.id).observe(this, Observer {
                binding.book = it
            })
        }
    }

    override fun onCreateOptionsMenu(menu: Menu?, inflater: MenuInflater?) {
        super.onCreateOptionsMenu(menu, inflater)
        inflater?.inflate(R.menu.detail, menu)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        if (item?.itemId == R.id.menu_edit_book) {
            binding.book?.let {
                val args = Bundle().apply {
                    putParcelable("book", Parcels.wrap(it))
                }
                navController.navigate(R.id.action_details_to_form, args)
            }
            return true
        }
        return super.onOptionsItemSelected(item)
    }
}
