package dominando.android.data

import dominando.android.data.model.Book
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Maybe

interface BooksRepository {
    fun saveBook(book: Book): Completable
    fun loadBooks(): Flowable<List<Book>>
    fun loadBook(bookId: String): Maybe<Book>
    fun remove(book: Book): Completable
}