package dominando.android.domain

import androidx.arch.core.executor.testing.InstantTaskExecutorRule
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import com.nhaarman.mockitokotlin2.any
import com.nhaarman.mockitokotlin2.mock
import com.nhaarman.mockitokotlin2.whenever
import dominando.android.data.BooksRepository
import dominando.android.data.model.Book
import dominando.android.data.model.MediaType
import dominando.android.data.model.Publisher
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.mockito.Mockito.verify
import java.util.*

class SaveBookUseCaseTest {
    @get:Rule
    val rule = InstantTaskExecutorRule()

    private val dummyBook = Book().apply {
        id = UUID.randomUUID().toString()
        title = "Dominando o Android"
        author = "Nelson Glauber"
        available = true
        coverUrl = ""
        pages = 954
        publisher = Publisher(UUID.randomUUID().toString(), "Novatec")
        year = 2018
        mediaType = MediaType.EBOOK
        rating = 5f
    }

    val repository: BooksRepository = mock()

    @Before
    fun init() {
        whenever(repository.saveBook(any()))
                .thenReturn(
                        MutableLiveData<Boolean>().apply {
                            value = true
                        }
                )
    }

    @Test
    fun testBookIsSaved() {
        // Given
        val useCase = SaveBookUseCase(repository)
        val observer = mock<Observer<Boolean>>()
        // When
        useCase.saveBook(dummyBook).observeForever(observer)
        // Then
        verify(observer).onChanged(true)
    }
}