package dominando.android.presentation

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import dominando.android.domain.ViewBookDetailsUseCase
import dominando.android.presentation.binding.BookConverter
import dominando.android.presentation.binding.Book as BookBinding

class BookDetailsViewModel(private val useCase: ViewBookDetailsUseCase) : ViewModel() {
    private val selectedBookId = MutableLiveData<String>()
    private var selectedBook: LiveData<BookBinding> =
            Transformations.switchMap(selectedBookId) { bookId ->
                Transformations.map(useCase.loadBook(bookId)) { book ->
                    BookConverter.fromData(book)
                }
            }

    fun getBook(id: String): LiveData<BookBinding> {
        selectedBookId.value = id
        return selectedBook
    }
}
