package dominando.android.presentation

import androidx.lifecycle.LiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import dominando.android.domain.ListBooksUseCase
import dominando.android.domain.RemoveBookUseCase
import dominando.android.presentation.binding.BookConverter
import dominando.android.presentation.binding.Book as BookBinding

class BookListViewModel(
        private val loadBooksUseCase: ListBooksUseCase,
        private val removeBookUseCase: RemoveBookUseCase

) : ViewModel() {
    private var booksList =
            Transformations.map(loadBooksUseCase.loadBooks()) { books ->
                books.map { book ->
                    BookConverter.fromData(book)
                }
            }

    fun getBooks(): LiveData<List<BookBinding>> = booksList

    fun remove(bookBinding: BookBinding): LiveData<Boolean> {
        val book = BookConverter.toData(bookBinding)
        return removeBookUseCase.remove(book)
    }
}
