package dominando.android.presentation

import android.app.Application
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModel
import dominando.android.data_room.database.AppDatabase
import dominando.android.data_room.LocalFileHelper
import dominando.android.data_room.RoomRepository
import dominando.android.domain.ListBooksUseCase
import dominando.android.domain.RemoveBookUseCase
import dominando.android.domain.SaveBookUseCase
import dominando.android.domain.ViewBookDetailsUseCase

class BookVmFactory(private val application: Application) : ViewModelProvider.NewInstanceFactory() {

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
//        val repo = FbRepository()
        val repo = RoomRepository(AppDatabase.getDatabase(application), LocalFileHelper())
        return when {
            modelClass.isAssignableFrom(BookListViewModel::class.java) ->
                BookListViewModel(ListBooksUseCase(repo), RemoveBookUseCase(repo)) as T
            modelClass.isAssignableFrom(BookDetailsViewModel::class.java) ->
                BookDetailsViewModel(ViewBookDetailsUseCase(repo)) as T
            modelClass.isAssignableFrom(BookFormViewModel::class.java) ->
                BookFormViewModel(SaveBookUseCase(repo)) as T
            else -> throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}