package dominando.android.presentation

import androidx.arch.core.executor.testing.InstantTaskExecutorRule
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import com.nhaarman.mockitokotlin2.any
import com.nhaarman.mockitokotlin2.mock
import com.nhaarman.mockitokotlin2.whenever
import dominando.android.data.BooksRepository
import dominando.android.data.model.Book
import dominando.android.data.model.MediaType
import dominando.android.data.model.Publisher
import dominando.android.domain.ViewBookDetailsUseCase
import dominando.android.presentation.binding.BookConverter
import dominando.android.presentation.binding.Book as BookBinding
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.mockito.Mockito.verify
import java.util.*

class DetailViewModelTest {
    @get:Rule
    val rule = InstantTaskExecutorRule()

    private val dummyBook = Book().apply {
        id = UUID.randomUUID().toString()
        title = "Dominando o Android"
        author = "Nelson Glauber"
        available = true
        coverUrl = ""
        pages = 954
        publisher = Publisher(UUID.randomUUID().toString(), "Novatec")
        year = 2018
        mediaType = MediaType.EBOOK
        rating = 5f
    }

    val repository: BooksRepository = mock()
    val useCase = ViewBookDetailsUseCase(repository)

    @Before
    fun init() {
        whenever(repository.loadBook(any()))
                .thenReturn(
                        MutableLiveData<Book>().apply {
                            value = dummyBook
                        }
                )
    }

    @Test
    fun testBookDetailsIsLoaded() {
        // Given
        val viewModel = BookDetailsViewModel(useCase)
        val observer = mock<Observer<BookBinding>>()
        // When
        viewModel.getBook("1").observeForever(observer)
        // Then
        verify(observer).onChanged(BookConverter.fromData(dummyBook))
    }
}