package com.example.myapplication

import android.content.Context
import android.os.Bundle
import android.util.TypedValue
import android.view.ViewGroup
import androidx.annotation.Dimension
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        val edgeMarginOfFirstAndLastCells = convertDpToPixels(this, 12f).toInt()
        val marginsBetweenCells = convertDpToPixels(this, 8f).toInt()

        recyclerView.adapter = object : RecyclerView.Adapter<RecyclerView.ViewHolder>() {
            override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
                return object : RecyclerView.ViewHolder(layoutInflater.inflate(R.layout.sub_item, parent, false)) {}
            }

            override fun getItemCount(): Int {
                return 3
            }

            override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
                val layoutParams =
                    holder.itemView.layoutParams as androidx.recyclerview.widget.RecyclerView.LayoutParams
                layoutParams.leftMargin = if (position == 0) edgeMarginOfFirstAndLastCells else marginsBetweenCells
                layoutParams.rightMargin = if (position < itemCount - 1) 0 else edgeMarginOfFirstAndLastCells
            }
        }

    }

    @Dimension
    fun convertDpToPixels(context: Context, dp: Float): Float {
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, context.resources.displayMetrics)
    }
}
