import com.android.build.gradle.api.ApplicationVariant

plugins {
    id("com.android.application")
    id("kotlin-android")
    id("kotlin-android-extensions")
    id("kotlinx-serialization")
    id("kotlin-kapt")
    id("androidx.navigation.safeargs.kotlin")
    id("de.mannodermaus.android-junit5")
}

android {
    compileSdkVersion(AndroidVersions.compileSdk)
    defaultConfig {
        applicationId = "com.google.codelabs.mdc.kotlin.shrine"
        minSdkVersion(AndroidVersions.minSdk)
        targetSdkVersion(AndroidVersions.targetSdk)
        versionCode = AndroidVersions.versionCode
        versionName = AndroidVersions.versionName
        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        vectorDrawables.useSupportLibrary = true
    }

    buildTypes {
        getByName("debug") {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android.txt"), "proguard-rules.pro")
        }

        getByName("release") {
            isMinifyEnabled = true
            proguardFiles(getDefaultProguardFile("proguard-android.txt"), "proguard-rules.pro")
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }

    lintOptions.apply {
        ignore("GoogleAppIndexingWarning")
        ignore("UnusedResources")
        isWarningsAsErrors = true
        isAbortOnError = true
        isQuiet = true
    }
}

android.applicationVariants.all(Action<ApplicationVariant> {
    val provider = this.assembleProvider

    val unitTestTask = tasks["test${this.name.capitalize()}UnitTest"]
    val instrumentationTestTask = tasks["connectedCheck"]
    val lintTask = tasks["lint${this.name.capitalize()}"]


    if (this.name.contains("debug")) {
        repeat(this.outputs.size) {
            provider?.get()?.dependsOn(lintTask)
        }
    } else {
        repeat(this.outputs.size) {
            instrumentationTestTask.dependsOn(unitTestTask)
            lintTask.dependsOn(instrumentationTestTask)
            provider?.get()?.dependsOn(lintTask)
        }
    }
})

tasks["preBuild"].dependsOn(":buildSrcVersions")

dependencies {
    // Support
    implementation(Libs.appcompat)

    // Design
    implementation(Libs.material)
    implementation(Libs.cardview)
    implementation(Libs.constraintlayout)

    // Lifecycle
    implementation(Libs.lifecycle_extensions)
    kapt(Libs.lifecycle_compiler)

    // Navigation
    implementation(Libs.navigation_fragment_ktx)
    implementation(Libs.navigation_ui_ktx)

    // Paging
    implementation(Libs.paging_runtime_ktx)
    testImplementation(Libs.paging_common_ktx)

    // Room
    implementation(Libs.room_runtime)
    kapt(Libs.room_compiler)
    implementation(Libs.room_ktx)
    testImplementation(Libs.room_testing)

    debugImplementation(Libs.androidx_test_core)
    debugImplementation(Libs.fragment_testing)

    // Test
    testImplementation(Libs.junit_junit)
    androidTestImplementation(Libs.androidx_test_core)
    androidTestImplementation(Libs.androidx_test_ext_junit)
    androidTestImplementation(Libs.androidx_test_runner)
    androidTestImplementation(Libs.espresso_core)
    androidTestImplementation(Libs.fragment_testing)

    // JUnit 5
    testImplementation(Libs.junit_jupiter_api)
    testRuntimeOnly(Libs.junit_jupiter_engine)
    testImplementation(Libs.junit_jupiter_params)
    testRuntimeOnly(Libs.junit_vintage_engine)

    // Retrofit
    implementation(Libs.retrofit)
    implementation(Libs.retrofit2_kotlin_coroutines_adapter)
    implementation(Libs.retrofit2_kotlinx_serialization_converter)

    // Kotlin
    implementation(Libs.kotlinx_coroutines_core)
    implementation(Libs.kotlinx_serialization_runtime)
    implementation(Libs.kotlin_stdlib_jdk7)

    // KTX
    implementation(Libs.core_ktx)
    implementation(Libs.collection_ktx)
    implementation(Libs.fragment_ktx)
}
