package com.google.codelabs.mdc.kotlin.shrine

import androidx.lifecycle.Lifecycle
import androidx.test.ext.junit.rules.ActivityScenarioRule
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Rule
import org.junit.Test

class MainActivityTest {

    @get:Rule
    val mainActivityScenarioRule = ActivityScenarioRule<MainActivity>(MainActivity::class.java)

    @Test
    fun onCreate_saveInstanceNull() {
        mainActivityScenarioRule.scenario.moveToState(Lifecycle.State.CREATED)
                .onActivity {
                    val fragments = it.supportFragmentManager.fragments
                    assertTrue(fragments.isNotEmpty())

                    val loginFragment = fragments[0]
                    assertTrue(loginFragment is LoginFragment)
                }
    }

    @Test
    fun onCreate_saveInstanceNotNull() {
        mainActivityScenarioRule.scenario.recreate()
                .onActivity {
                    val fragments = it.supportFragmentManager.fragments
                    assertEquals(1, fragments.size)
                }
    }

    @Test
    fun navigateTo_addToBackStackTrue() {
        mainActivityScenarioRule.scenario.onActivity {
            it.navigateTo(ProductGridFragment(), true)
            it.onBackPressed()


            val fragments = it.supportFragmentManager.fragments
            assertEquals(1, fragments.size)
        }
    }

    @Test
    fun navigateTo_addToBackStackFalse() {
        mainActivityScenarioRule.scenario.onActivity {
            it.navigateTo(ProductGridFragment(), false)
            it.onBackPressed()
        }

        assertTrue(mainActivityScenarioRule.scenario.state.isAtLeast(Lifecycle.State.DESTROYED))
    }
}
