package com.google.codelabs.mdc.kotlin.shrine

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import org.intellij.lang.annotations.Language

/**
 * Fragment representing the login screen for Shrine.
 */
class LoginFragment : Fragment() {

    override fun onCreateView(
            inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        // Inflate the layout for this fragment
        val view = inflater.inflate(R.layout.shr_login_fragment, container, false)


        return view
    }

    @Language("RegExp")
    fun isPasswordValid(password: String?): Boolean =
            !password.isNullOrBlank() && password.length in 8..16 &&
                    password.contains(Regex("[A-Z]")) &&
                    password.contains(Regex("[a-z]")) &&
                    password.contains(Regex("\\d")) &&
                    password.contains(Regex("[\\[\\\\^$.|?*+(){}\\]!@#￥%&/_\\-=]")) &&
                    password.all { !it.isWhitespace() }
}
