package com.google.codelabs.mdc.kotlin.shrine

import org.junit.jupiter.api.Assertions.assertFalse
import org.junit.jupiter.api.Assertions.assertTrue
import org.junit.jupiter.params.ParameterizedTest
import org.junit.jupiter.params.provider.NullAndEmptySource
import org.junit.jupiter.params.provider.ValueSource

internal class LoginFragmentTest {

    private val loginFragment: LoginFragment = LoginFragment()

    // password within alphabet, caps char, digit, special char, no space, in 8..16
    @ParameterizedTest
    @NullAndEmptySource
    @ValueSource(strings = ["1", "49483", "1_43kj*GUY f0",
        "fiajfnaofjqpfiddjlffajkljklafjklafjklfjklaf", "474838382728", "fj",
        "jfkdjsldjkk", "1jdkdjfifjfj", "j1Ijlijdirnh", "jfijnbijd_o", "1jfibijflci_", "WOJFODKJIJK",
        "_&^$#@$%$^&I(",
        "_&^", "WWRE"])
    fun isPasswordValid_False(password: String?) {
        assertFalse(loginFragment.isPasswordValid(password))
    }

    @ParameterizedTest
    @ValueSource(strings = ["2jfkW_3ojk", "38fJn_uW", "jidloa&^%7653Jhu"])
    fun isPasswordValid_True(password: String?) {
        assertTrue(loginFragment.isPasswordValid(password))
    }
}