package com.kcoppock.childfragmenttest

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.FragmentManager

class MainActivity : AppCompatActivity() {
    init {
        FragmentManager.enableDebugLogging(true)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        logId("onCreate(): savedInstanceState == $savedInstanceState")
        super.onCreate(savedInstanceState)

        if (savedInstanceState == null) {
            supportFragmentManager.beginTransaction()
                .add(ParentHeadlessFragment(), "parent")
                .commit()
        }
    }

    override fun onSaveInstanceState(outState: Bundle) {
        logId("onSaveInstanceState()")
        super.onSaveInstanceState(outState)
    }
}
