package com.kcoppock.childfragmenttest

import android.os.Bundle
import androidx.fragment.app.Fragment

class ParentHeadlessFragment : Fragment() {
    override fun onCreate(savedInstanceState: Bundle?) {
        logId("onCreate() with savedInstanceState = $savedInstanceState")
        super.onCreate(savedInstanceState)

        if (savedInstanceState == null) {
            childFragmentManager.beginTransaction()
                .add(ChildHeadlessFragment(), "child")
                .commit()
        }
    }

    override fun onSaveInstanceState(outState: Bundle) {
        logId("onSaveInstanceState()")
        super.onSaveInstanceState(outState)
    }
}