package com.innercirclesoftware.supportpropagationbug2;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.transition.AutoTransition;
import android.transition.SidePropagation;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    ViewGroup rootViewGroup;

    ViewGroup nativeLayout;
    View nativeOne;
    View nativeTwo;
    View nativeThree;

    ViewGroup supportLayout;
    View supportOne;
    View supportTwo;
    View supportThree;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        bindsViews();
        setupClickListeners();
    }

    private void bindsViews() {
        rootViewGroup = findViewById(R.id.root);

        nativeLayout = findViewById(R.id.native_constraint_layout);
        nativeOne = findViewById(R.id.native_one);
        nativeTwo = findViewById(R.id.native_two);
        nativeThree = findViewById(R.id.native_three);

        supportLayout = findViewById(R.id.support_constraint_layout);
        supportOne = findViewById(R.id.support_one);
        supportTwo = findViewById(R.id.support_two);
        supportThree = findViewById(R.id.support_three);
    }

    private void setupClickListeners() {
        nativeLayout.setOnClickListener(this);
        supportLayout.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        if (v == nativeLayout) {
            //native transitions
            SidePropagation propagation = new SidePropagation();
            propagation.setSide(Gravity.END);

            Transition propagatedTransition = new AutoTransition();
            //start delay works as expected, unlike the support transition
            propagatedTransition.setStartDelay(150);
            propagatedTransition.setPropagation(propagation);

            TransitionManager.beginDelayedTransition(rootViewGroup, propagatedTransition);
            toggleChildren(nativeLayout);
        } else {
            //support transitions
            android.support.transition.SidePropagation propagation = new android.support.transition.SidePropagation();
            propagation.setSide(Gravity.END);

            android.support.transition.Transition propagatedTransition = new android.support.transition.AutoTransition();
            //Using a start delay causes the support version to not propagate the transition when animating out
            propagatedTransition.setStartDelay(150);
            propagatedTransition.setPropagation(propagation);

            android.support.transition.TransitionManager.beginDelayedTransition(rootViewGroup, propagatedTransition);
            toggleChildren(supportLayout);
        }
    }

    private void toggleChildren(ViewGroup layout) {
        int newVisibility = layout.getChildAt(0).getVisibility() == View.VISIBLE ? View.GONE : View.VISIBLE;
        for (int i = 0; i < layout.getChildCount(); i++) {
            layout.getChildAt(i).setVisibility(newVisibility);
        }
    }
}
