package com.mycelium.wallet.databinding;

import android.databinding.Bindable;
import android.databinding.DataBindingComponent;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mycelium.wallet.activity.main.address.AddressFragmentViewModel;

public abstract class AddressFragmentBinding extends ViewDataBinding {
  @NonNull
  public final LinearLayout llAddress;

  @Bindable
  protected FragmentActivity mActivity;

  @Bindable
  protected AddressFragmentViewModel mViewModel;

  protected AddressFragmentBinding(DataBindingComponent _bindingComponent, View _root,
      int _localFieldCount, LinearLayout llAddress) {
    super(_bindingComponent, _root, _localFieldCount);
    this.llAddress = llAddress;
  }

  public abstract void setActivity(@Nullable FragmentActivity activity);

  @Nullable
  public FragmentActivity getActivity() {
    return mActivity;
  }

  public abstract void setViewModel(@Nullable AddressFragmentViewModel viewModel);

  @Nullable
  public AddressFragmentViewModel getViewModel() {
    return mViewModel;
  }

  @NonNull
  public static AddressFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot) {
    return inflate(inflater, root, attachToRoot, DataBindingUtil.getDefaultComponent());
  }

  @NonNull
  public static AddressFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot, @Nullable DataBindingComponent component) {
    return DataBindingUtil.<AddressFragmentBinding>inflate(inflater, com.mycelium.wallet.R.layout.address_fragment, root, attachToRoot, component);
  }

  @NonNull
  public static AddressFragmentBinding inflate(@NonNull LayoutInflater inflater) {
    return inflate(inflater, DataBindingUtil.getDefaultComponent());
  }

  @NonNull
  public static AddressFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable DataBindingComponent component) {
    return DataBindingUtil.<AddressFragmentBinding>inflate(inflater, com.mycelium.wallet.R.layout.address_fragment, null, false, component);
  }

  public static AddressFragmentBinding bind(@NonNull View view) {
    return bind(view, DataBindingUtil.getDefaultComponent());
  }

  public static AddressFragmentBinding bind(@NonNull View view,
      @Nullable DataBindingComponent component) {
    return (AddressFragmentBinding)bind(component, view, com.mycelium.wallet.R.layout.address_fragment);
  }
}
