/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DataTransferBL;

import com.example.twolibs.DataTransferBL.DataTransferFile;
import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataDownLoadHelper {
    private static String CLASS_NAME = "DataTransferHelper";

    public static HashMapX<String, DataTransferFile> doLoadDataFilesXML(HashMapX<String, DataTransferGroup> pAllDownLoads) {
        String FUNC_NAME = "doLoadDataFilesXML";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadDataFilesXML", TraceHandler.Category.ENTRY, "", 0);
        HashMapX<String, DataTransferFile> allTransferFiles = new HashMapX<String, DataTransferFile>();
        for (DataTransferGroup dataGroup : pAllDownLoads.values()) {
            String dataGroupConfigPath = DataTransferManager.getDownloadConfig(dataGroup.dataGroupName);
            String dataGroupPrefix = DataTransferManager.getDownloadPath(dataGroup.dataGroupName);
            DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocumentRaw(dataGroupConfigPath);
            if (resp.result == GenericManager.Response.OK) {
                try {
                    Element element = resp.doc.getDocumentElement();
                    NodeList nodeTopList = element.getElementsByTagName("DataFiles");
                    Element owner = (Element)nodeTopList.item(0);
                    NodeList nodeList = owner.getElementsByTagName("DataFile");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element node = (Element)nodeList.item(i);
                        DataTransferFile dataTransferFile = DataDownLoadHelper.fromDataFileXML(node);
                        dataTransferFile.fullPath = dataGroupPrefix + dataTransferFile.storageName;
                        if (dataTransferFile == null) continue;
                        allTransferFiles.put(dataTransferFile.shortName, dataTransferFile);
                    }
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadDataFilesXML", TraceHandler.Category.EXIT, "Loaded " + allTransferFiles.size(), 0);
                }
                catch (Exception e) {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadDataFilesXML", TraceHandler.Category.EXIT, "XML Pasing Exception = " + e.getMessage(), 0);
                }
                continue;
            }
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadDataFilesXML", TraceHandler.Category.EXIT, "Document not loaded", 0);
        }
        return allTransferFiles;
    }

    private static DataTransferGroup fromDataGroupXML(Element pNode) {
        NodeList nodes;
        String FUNC_NAME = "fromDataGroupXML";
        DataTransferGroup dataTransferGroup = new DataTransferGroup();
        try {
            nodes = pNode.getElementsByTagName("title");
            dataTransferGroup.dataGroupName = nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataGroupXML", TraceHandler.Category.EXIT, "XML title Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            nodes = pNode.getElementsByTagName("set");
            dataTransferGroup.currentSet = nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataGroupXML", TraceHandler.Category.EXIT, "XML set Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            nodes = pNode.getElementsByTagName("folder");
            dataTransferGroup.dataGroupFolder = nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataGroupXML", TraceHandler.Category.EXIT, "XML folder Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            nodes = pNode.getElementsByTagName("version");
            dataTransferGroup.comment = dataTransferGroup.currentSet + " v" + nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataGroupXML", TraceHandler.Category.EXIT, "XML version Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            nodes = pNode.getElementsByTagName("timeStamp");
            String temp = nodes.item(0).getTextContent();
            dataTransferGroup.timeStamp = DataConvert.parseISOyyyymmddhhmmss(temp);
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataGroupXML", TraceHandler.Category.EXIT, "XML timeStamp Exception = " + e.getMessage(), 0);
            return null;
        }
        return dataTransferGroup;
    }

    public static HashMapX<String, DataTransferGroup> doLoadDownloadDataGroups() {
        String FUNC_NAME = "doLoadDownloadDataGroups";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadDownloadDataGroups", TraceHandler.Category.ENTRY, "", 0);
        HashMapX<String, DataTransferGroup> allTransfers = new HashMapX<String, DataTransferGroup>();
        DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(DataTransferManager.FileType.DATADOWNLOADSTATE);
        if (resp.result == GenericManager.Response.OK) {
            try {
                Element element = resp.doc.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("DataGroup");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element node = (Element)nodeList.item(i);
                    DataTransferGroup dataTransferGroup = DataDownLoadHelper.fromDataGroupXML(node);
                    if (dataTransferGroup == null) continue;
                    dataTransferGroup.transferDirection = "Down";
                    allTransfers.put(dataTransferGroup.dataGroupName, dataTransferGroup);
                }
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadDownloadDataGroups", TraceHandler.Category.EXIT, "Loaded " + allTransfers.size(), 0);
            }
            catch (Exception e) {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadDownloadDataGroups", TraceHandler.Category.EXIT, "XML Pasing Exception = " + e.getMessage(), 0);
            }
        } else {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadDownloadDataGroups", TraceHandler.Category.EXIT, "Document not loaded", 0);
        }
        return allTransfers;
    }

    private static DataTransferFile fromDataFileXML(Element pNode) {
        NodeList nodes;
        String FUNC_NAME = "fromDataFileXML";
        DataTransferFile dataTransferFile = new DataTransferFile();
        try {
            nodes = pNode.getElementsByTagName("shortName");
            dataTransferFile.shortName = nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataFileXML", TraceHandler.Category.EXIT, "XML shortname Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            nodes = pNode.getElementsByTagName("storageName");
            dataTransferFile.storageName = nodes.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromDataFileXML", TraceHandler.Category.EXIT, "XML storageName Exception = " + e.getMessage(), 0);
            return null;
        }
        return dataTransferFile;
    }

    public static HashMapX<String, DataTransferGroup> doLoadTest() {
        HashMapX<String, DataTransferGroup> transfers = new HashMapX<String, DataTransferGroup>();
        DataTransferGroup transfer = new DataTransferGroup();
        transfer.dataGroupName = "Fares data";
        transfer.transferDirection = "Down";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 14, 0);
        transfer.comment = "OK";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "Timetable base data";
        transfer.transferDirection = "Down";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 25, 0);
        transfer.comment = "OK";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "Fares data";
        transfer.transferDirection = "Down";
        long lreq = DataConvert.getTimeInMillis(DataConvert.DATENULL);
        lreq -= 300000L;
        transfer.timeStamp = DataConvert.setTimeInMillis(lreq -= 300000L);
        transfer.comment = "Timetable snapshot";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "User profiles";
        transfer.transferDirection = "Down";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 10, 0);
        transfer.comment = "OK";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "Sales data";
        transfer.transferDirection = "Up";
        lreq = DataConvert.getTimeInMillis(DataConvert.DATENULL);
        lreq -= 120000L;
        transfer.timeStamp = DataConvert.setTimeInMillis(lreq -= 2000L);
        transfer.comment = "OK - \u00a310.05 2 coupons 3 requests";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "Retail items";
        transfer.transferDirection = "Down";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 5, 0);
        transfer.comment = "OK";
        transfers.put(transfer.dataGroupName, transfer);
        transfer = new DataTransferGroup();
        transfer.dataGroupName = "Diagnostics";
        transfer.transferDirection = "Up";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 1, 0);
        transfer.comment = "OK - 0 requests";
        transfers.put(transfer.dataGroupName, transfer);
        return transfers;
    }
}

