/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DevicesBL;

import android.app.IntentService;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class CCSTPrinterService
extends IntentService {
    public static String CLASS_NAME = "CCSTPrinterService";
    private int result = 0;
    private Date lastMsgTime = null;
    public static final String MESSAGE_REQUEST = "message_request";
    public static final String MESSAGE_ID = "message_id";
    public static final String MESSAGE_RESPONSE = "message_response";
    public static final String MESSAGE_ORIGIN = "message_origin";
    public static final String MAC_ADDRESS = "mac_address";
    public static final String MESSAGE_CONTENT = "message_content";
    public static final String RESULT = "result";
    public static final String NOTIFICATION = "com.example.twolibs";
    private BluetoothAdapter bluetoothAdapter;
    public static final int REQUEST_NONE = -1;
    public static final int REQUEST_CONNECT = 20;
    public static final int REQUEST_STATUS = 21;
    public static final int REQUEST_PRINT = 22;
    public static final int REQUEST_CLOSE = 23;
    public static final int REQUEST_FAILED = -2;
    static PrinterState iCCST = PrinterState.NOBLUETOOTH;
    static BluetoothDevice blueToothDevice = null;
    static BluetoothSocket blueToothSocket = null;
    static SendReceiveBytes sendReceiveBT = null;
    static long lastMessage = 0L;
    private static final int ENABLE_BT_REQUEST_CODE = 1;
    public static final int MESSAGE_WRITE = 1;
    public static final int MESSAGE_READ = 2;
    static String readMessage = "";
    static String printerResponse = "";
    static String macAddress = "00:12:6F:00:94:80";
    static boolean printerConnected = false;
    int activeListener = 0;
    static int msgNo = 0;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            String FUNC_NAME = "handleMessage";
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.ENTRY, "Type:" + msg.what, 0);
            switch (msg.what) {
                case 1: {
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.ENTRY, "Write:" + msg.arg1, 0);
                    break;
                }
                case 2: {
                    byte[] readBuf = (byte[])msg.obj;
                    readMessage = new String(readBuf, 0, msg.arg1);
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.ENTRY, "Read:" + readMessage, 0);
                    CCSTPrinterService.this.ReadPrinter(readMessage);
                }
            }
        }
    };

    public CCSTPrinterService() {
        super("CCSTPrinterService");
    }

    protected void onHandleIntent(Intent intent) {
        String FUNC_NAME = "onHandleIntent";
        int request = intent.getIntExtra(MESSAGE_REQUEST, -1);
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onHandleIntent", TraceHandler.Category.ENTRY, "Service called " + request + "(" + ++msgNo + ")", 0);
        switch (request) {
            case 20: {
                String requestedMac = intent.getStringExtra(MAC_ADDRESS);
                this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (this.bluetoothAdapter == null) {
                    this.publishResults(request, "Bluetooth not supported", this.result);
                    break;
                }
                if (!this.bluetoothAdapter.isEnabled()) {
                    this.publishResults(request, "Bluetooth switched off", this.result);
                }
                if (!Objects.equals(requestedMac, macAddress) && printerConnected) {
                    this.publishResults(request, "Closing down", this.result);
                    sendReceiveBT.cancel();
                }
                if (requestedMac.length() != 0) {
                    macAddress = requestedMac;
                }
                this.ConnectDevice(request, macAddress, true);
                break;
            }
            case 21: {
                long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
                if (dteMessage - lastMessage > 2000L) {
                    // empty if block
                }
                if (!printerConnected) {
                    this.ConnectDevice(request, macAddress, false);
                }
                this.QueryPrinter(request);
                break;
            }
            case 22: {
                this.result = 0;
                String msgContent = intent.getStringExtra(MESSAGE_CONTENT);
                Log.d((String)"TAG ", (String)"Print request");
                if (!printerConnected) {
                    this.ConnectDevice(request, macAddress, false);
                }
                this.SendPrinter(request, msgContent);
                break;
            }
            case 23: {
                this.result = -1;
                this.publishResults(request, "Closing down", this.result);
                if (sendReceiveBT != null) {
                    sendReceiveBT.cancel();
                }
                this.stopSelf();
                break;
            }
            case -2: {
                this.result = 0;
                String msgError = intent.getStringExtra(MESSAGE_CONTENT);
                Log.d((String)"TAG ", (String)"Print request");
                this.publishResults(request, msgError, this.result);
                break;
            }
            default: {
                this.result = 0;
                this.publishResults(request, "No request", this.result);
            }
        }
    }

    private void publishResults(int request, String message, int result) {
        String FUNC_NAME = "publishResults";
        Intent intent = new Intent(NOTIFICATION);
        intent.putExtra(MESSAGE_REQUEST, request);
        intent.putExtra(MESSAGE_ID, msgNo);
        intent.putExtra(MESSAGE_RESPONSE, message);
        intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);
        intent.putExtra(RESULT, result);
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "publishResults", TraceHandler.Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);
        this.sendBroadcast(intent);
    }

    public void ConnectDevice(int request, String strMAC, boolean pQueryrequest) {
        String FUNC_NAME = "ConnectDevice";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "ConnectDevice", TraceHandler.Category.ENTRY, "Request " + request, 0);
        if (printerConnected) {
            iCCST = PrinterState.READY;
            this.QueryPrinter(request);
            return;
        }
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        blueToothDevice = this.bluetoothAdapter.getRemoteDevice(strMAC);
        Integer port = 1;
        while (port <= 1) {
            this.simpleComm(request, (int)port, pQueryrequest);
            Integer n = port;
            Integer n2 = port = Integer.valueOf(port + 1);
        }
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "ConnectDevice", TraceHandler.Category.EXIT, "", 0);
    }

    protected void simpleComm(int request, Integer port, boolean pQueryrequest) {
        block11: {
            String FUNC_NAME = "simpleComm";
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "simpleComm", TraceHandler.Category.ENTRY, "Request " + request + " port " + port, 0);
            this.bluetoothAdapter.cancelDiscovery();
            try {
                Method m = blueToothDevice.getClass().getMethod("createInsecureRfcommSocket", Integer.TYPE);
                blueToothSocket = (BluetoothSocket)m.invoke((Object)blueToothDevice, port);
                if (blueToothSocket == null) {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "simpleComm", TraceHandler.Category.ERROREXIT, "Blue tooth socket null", 0);
                }
                assert (blueToothSocket != null) : "Socket is Null";
                try {
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "simpleComm", TraceHandler.Category.ERROREXIT, "Connecting to socket: attempt " + this.activeListener, 0);
                    blueToothSocket.connect();
                }
                catch (IOException e) {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "simpleComm", TraceHandler.Category.ERROREXIT, "Connection failed: attempt " + this.activeListener, 0);
                }
                if (blueToothSocket == null) break block11;
                iCCST = PrinterState.READY;
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "simpleComm", TraceHandler.Category.ENTRY, " Start send/receive thread: " + this.activeListener, 0);
                sendReceiveBT = new SendReceiveBytes(blueToothSocket, this.activeListener);
                new Thread(sendReceiveBT).start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "simpleComm", TraceHandler.Category.ENTRY, "Interrupted sleep: " + this.activeListener, 0);
                }
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "simpleComm", TraceHandler.Category.ENTRY, "Slept - ready to listen on: " + this.activeListener, 0);
                if (pQueryrequest) {
                    this.QueryPrinter(request);
                }
            }
            catch (NoSuchMethodException ex) {
                Log.e((String)((Object)((Object)this)).toString(), (String)("NoSuchMethodException " + ex.getMessage()));
            }
            catch (IllegalAccessException ex) {
                Log.e((String)((Object)((Object)this)).toString(), (String)("IllegalAccessException " + ex.getMessage()));
            }
            catch (InvocationTargetException ex) {
                Log.e((String)((Object)((Object)this)).toString(), (String)("InvocationTargetException " + ex.getMessage()));
            }
        }
    }

    public void QueryPrinter(int request) {
        String FUNC_NAME = "QueryPrinter";
        byte[] querym = new byte[]{63, 63, 63, 63, 63};
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "QueryPrinter", TraceHandler.Category.ENTRY, "Request " + request + " State: " + (Object)((Object)iCCST), 0);
        long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
        if (iCCST == PrinterState.READY) {
            iCCST = PrinterState.QUERY;
            printerResponse = "";
            lastMessage = dteMessage;
            sendReceiveBT.write(querym);
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "QueryPrinter", TraceHandler.Category.EXIT, "sent query message " + querym, 0);
        } else {
            this.result = 0;
            this.publishResults(request, "Printer not ready " + (Object)((Object)iCCST), this.result);
        }
    }

    public void SendPrinter(int request, String msg) {
        String FUNC_NAME = "SendPrinter";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "SendPrinter", TraceHandler.Category.ENTRY, "Request " + request + " state " + (Object)((Object)iCCST), 0);
        byte[] bSOH = new byte[]{1};
        String sSOH = new String(bSOH);
        byte[] bEOT = new byte[]{4};
        String sEOT = new String(bEOT);
        String sWrappedMsg = sSOH + "00" + msg + sEOT;
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "SendPrinter", TraceHandler.Category.ENTRY, "Request >" + sWrappedMsg + "<", 0);
        byte[] querym = sWrappedMsg.getBytes();
        for (int i = 0; i < querym.length; ++i) {
            if (i <= 0 || querym[i] != 35) continue;
            querym[i] = 32;
        }
        long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
        if (iCCST == PrinterState.READY) {
            iCCST = PrinterState.PRINTING;
            printerResponse = "";
            lastMessage = dteMessage;
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "SendPrinter", TraceHandler.Category.ENTRY, "Sending", 0);
            sendReceiveBT.write(querym);
        } else {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "SendPrinter", TraceHandler.Category.EXIT, "NOT SENT - printer not in correct state", 0);
        }
    }

    public void ReadPrinter(String msg) {
        String FUNC_NAME = "ReadPrinter";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "ReadPrinter", TraceHandler.Category.ENTRY, "Read:" + msg, 0);
        printerResponse = printerResponse + msg;
        byte[] bSTX = new byte[]{2};
        String sSTX = new String(bSTX);
        byte[] bETX = new byte[]{3};
        String sETX = new String(bETX);
        if (printerResponse.contains(sETX)) {
            int request = iCCST == PrinterState.PRINTING ? 22 : 21;
            iCCST = PrinterState.READY;
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "ReadPrinter", TraceHandler.Category.ENTRY, "Message:" + printerResponse, 0);
            this.result = -1;
            this.publishResults(request, printerResponse, this.result);
        }
    }

    private class SendReceiveBytes
    implements Runnable {
        private BluetoothSocket btSocket;
        private InputStream btInputStream = null;
        private OutputStream btOutputStream = null;
        int thisListener = -1;

        public SendReceiveBytes(BluetoothSocket socket, int intListener) {
            String FUNC_NAME = "SendReceiveBytes";
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "SendReceiveBytes", TraceHandler.Category.ENTRY, "Channel:" + intListener, 0);
            this.btSocket = socket;
            this.thisListener = intListener;
            try {
                this.btInputStream = this.btSocket.getInputStream();
                this.btOutputStream = this.btSocket.getOutputStream();
            }
            catch (IOException streamError) {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "SendReceiveBytes", TraceHandler.Category.ERROREXIT, "Error when getting input or output Stream:" + streamError.getMessage(), 0);
            }
        }

        @Override
        public void run() {
            String FUNC_NAME = "run";
            byte[] buffer = new byte[1024];
            printerConnected = true;
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "run", TraceHandler.Category.ENTRY, "Active:" + CCSTPrinterService.this.activeListener + " This:" + this.thisListener, 0);
            while (CCSTPrinterService.this.activeListener == this.thisListener) {
                try {
                    int bytes = this.btInputStream.read(buffer);
                    byte[] readMsg = Arrays.copyOf(buffer, bytes);
                    CCSTPrinterService.this.mHandler.obtainMessage(2, bytes, -1, (Object)readMsg).sendToTarget();
                }
                catch (IOException e) {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "run", TraceHandler.Category.ERROREXIT, e.getMessage(), 0);
                    break;
                }
            }
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "run", TraceHandler.Category.EXIT, "Active:" + CCSTPrinterService.this.activeListener + " This:" + this.thisListener, 0);
        }

        public void write(byte[] bytes) {
            String FUNC_NAME = "write";
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "write", TraceHandler.Category.ENTRY, "Length " + bytes.length, 0);
            try {
                this.btOutputStream.write(bytes);
            }
            catch (IOException e) {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "write", TraceHandler.Category.ERROREXIT, e.getMessage(), 0);
            }
        }

        public void cancel() {
            String FUNC_NAME = "cancel";
            if (this.btInputStream != null) {
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "cancel", TraceHandler.Category.ENTRY, "Close inputstream", 0);
                try {
                    this.btInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.btInputStream = null;
            }
            if (this.btOutputStream != null) {
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "cancel", TraceHandler.Category.ENTRY, "Close outputstream", 0);
                try {
                    this.btOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.btOutputStream = null;
            }
            if (this.btSocket != null) {
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "cancel", TraceHandler.Category.ENTRY, "Close socket", 0);
                try {
                    this.btSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.btSocket = null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            iCCST = PrinterState.NOTREADY;
            printerConnected = false;
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "cancel", TraceHandler.Category.EXIT, "End of closedown of:" + CCSTPrinterService.this.activeListener, 0);
        }
    }

    public static enum PrinterState {
        NOBLUETOOTH,
        BLUETOOTH,
        NOTREADY,
        READY,
        QUERY,
        PRINTING;

    }
}

