/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DevicesBL;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.example.twolibs.DevicesBL.IngenicoCommonInterface;
import com.ingenico.pclservice.IPclService;
import com.ingenico.pclservice.TransactionIn;
import com.ingenico.pclservice.TransactionOut;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class IngenicoCommon
extends Activity
implements IngenicoCommonInterface {
    public static final String TAG = "INGENICO";
    protected IPclService mPclService = null;
    private static Boolean m_BarCodeActivated = false;
    private static Boolean m_PrinterActivated = false;
    private BarCodeReceiver m_BarCodeReceiver = null;
    private StateReceiver m_StateReceiver = null;
    protected PclServiceConnection mServiceConnection;
    protected int mReleaseService;
    protected boolean mBound = false;
    public int SN;
    public int PN;
    protected _SYSTEMTIME sysTime;

    protected void onResume() {
        Log.d((String)TAG, (String)"onResume");
        super.onResume();
        this.initService();
        this.initBarCodeReceiver();
        this.initStateReceiver();
    }

    protected void onPause() {
        Log.d((String)TAG, (String)"onPause");
        super.onPause();
        this.releaseBarCodeReceiver();
        this.releaseStateReceiver();
    }

    public abstract void onPclServiceConnected();

    protected void initService() {
        if (!this.mBound) {
            Log.d((String)TAG, (String)"initService");
            this.mServiceConnection = new PclServiceConnection();
            Intent i = new Intent();
            i.setClassName("com.ingenico.pclservice", "com.ingenico.pclservice.PclService");
            this.mBound = this.getApplicationContext().bindService(i, (ServiceConnection)this.mServiceConnection, 1);
        }
    }

    protected void releaseService() {
        if (this.mBound) {
            Log.d((String)TAG, (String)"releaseService");
            this.getApplicationContext().unbindService((ServiceConnection)this.mServiceConnection);
            this.mBound = false;
        }
    }

    private void initBarCodeReceiver() {
        if (this.m_BarCodeReceiver == null) {
            this.m_BarCodeReceiver = new BarCodeReceiver(this);
            IntentFilter intentfilter = new IntentFilter("com.ingenico.pclservice.action.BARCODE_EVENT");
            this.registerReceiver(this.m_BarCodeReceiver, intentfilter);
        }
    }

    private void releaseBarCodeReceiver() {
        if (this.m_BarCodeReceiver != null) {
            this.unregisterReceiver(this.m_BarCodeReceiver);
            this.m_BarCodeReceiver = null;
        }
    }

    public Boolean openBarCode() {
        Log.d((String)TAG, (String)"openBarCode");
        if (this.mPclService != null && !m_BarCodeActivated.booleanValue()) {
            m_BarCodeActivated = this.setBarCodeActivation(true);
        }
        return m_BarCodeActivated;
    }

    public Boolean closeBarCode() {
        Log.d((String)TAG, (String)"closeBarCode");
        if (this.mPclService != null && m_BarCodeActivated.booleanValue()) {
            m_BarCodeActivated = this.setBarCodeActivation(false) == false;
        }
        return m_BarCodeActivated;
    }

    public Boolean reopenBarCode() {
        if (m_BarCodeActivated.booleanValue()) {
            this.closeBarCode();
        }
        return this.openBarCode();
    }

    private Boolean setBarCodeActivation(boolean activateBarCode) {
        boolean result = false;
        byte[] array = null;
        if (this.mPclService != null) {
            array = new byte[1];
            try {
                if (activateBarCode) {
                    result = this.mPclService.openBarcode(array);
                    if (result && array[0] != 0) {
                        result = false;
                    }
                } else {
                    this.mPclService.closeBarcode(array);
                    result = true;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean openPrinter() {
        if (this.mPclService != null && !m_PrinterActivated.booleanValue()) {
            m_PrinterActivated = this.setPrinterActivation(true);
        }
        return m_PrinterActivated;
    }

    public boolean closePrinter() {
        if (m_PrinterActivated.booleanValue()) {
            m_PrinterActivated = !this.setPrinterActivation(false);
        }
        return m_PrinterActivated;
    }

    private boolean setPrinterActivation(boolean activatePrinter) {
        boolean result = false;
        byte[] array = null;
        if (this.mPclService != null) {
            array = new byte[1];
            try {
                result = activatePrinter ? this.mPclService.openPrinter(array) : this.mPclService.closePrinter(array);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean printText(String strText) {
        boolean Result = false;
        if (this.openPrinter()) {
            byte[] PrintResult = new byte[1];
            try {
                Result = this.mPclService.printText(strText, PrintResult);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)String.format("TO PRINT : %s", strText));
            Log.d((String)TAG, (String)String.format("printText result=%d", PrintResult[0]));
            this.closePrinter();
        }
        return Result;
    }

    public boolean printBitmap(byte[] bmpBuf, int bmpSize) {
        boolean result = false;
        if (bmpBuf != null && this.openPrinter()) {
            byte[] printResult = new byte[1];
            try {
                result = this.mPclService.printBitmap(bmpBuf, bmpSize, printResult);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)String.format("printBitMap result=%d", printResult[0]));
            this.closePrinter();
        }
        return result;
    }

    boolean storeLogo(String name, int type, byte[] bmpBuf, int bmpSize, byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.storeLogo(name, type, bmpBuf, bmpSize, result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean printLogo(String name, byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.printLogo(name, result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean getPrinterStatus(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.getPrinterStatus(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean getTime() {
        boolean ret = false;
        byte[] time = new byte[16];
        if (this.mPclService != null) {
            try {
                this.sysTime = new _SYSTEMTIME();
                ret = this.mPclService.getTerminalTime(time);
                ByteBuffer bbTime = ByteBuffer.wrap(time);
                bbTime.order(ByteOrder.LITTLE_ENDIAN);
                this.sysTime.wYear = bbTime.getShort();
                this.sysTime.wMonth = bbTime.getShort();
                this.sysTime.wDayOfWeek = bbTime.getShort();
                this.sysTime.wDay = bbTime.getShort();
                this.sysTime.wHour = bbTime.getShort();
                this.sysTime.wMinute = bbTime.getShort();
                this.sysTime.wSecond = bbTime.getShort();
                this.sysTime.wMilliseconds = bbTime.getShort();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean setTime(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.setTerminalTime(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public boolean getTermInfo() {
        boolean ret = false;
        byte[] serialNbr = new byte[4];
        byte[] productNbr = new byte[4];
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.getTerminalInfo(serialNbr, productNbr);
                ByteBuffer bbSN = ByteBuffer.wrap(serialNbr);
                ByteBuffer bbPN = ByteBuffer.wrap(productNbr);
                bbSN.order(ByteOrder.LITTLE_ENDIAN);
                bbPN.order(ByteOrder.LITTLE_ENDIAN);
                this.SN = bbSN.getInt();
                this.PN = bbPN.getInt();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean getFullSerialNumber(byte[] serialNbr) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.getFullSerialNumber(serialNbr);
                ByteBuffer bbSN = ByteBuffer.wrap(serialNbr);
                bbSN.order(ByteOrder.LITTLE_ENDIAN);
                this.SN = bbSN.getInt();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean getComponentsInfo() {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.getTerminalComponents("Running.lst");
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public boolean doTransaction(TransactionIn transIn, TransactionOut transOut) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.doTransaction(transIn, transOut);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean doTransactionEx(TransactionIn transIn, TransactionOut transOut, int appNumber, byte[] inBuffer, int inBufferSize, byte[] outBuffer, long[] outBufferSize) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.doTransactionEx(transIn, transOut, appNumber, inBuffer, inBufferSize, outBuffer, outBufferSize);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean doUpdate(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.doUpdate(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean resetTerminal(int resetInfo) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.resetTerminal(resetInfo);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean sendMsg(byte[] msg, int[] byteSent) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.sendMessage(msg, byteSent);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean recvMsg(byte[] msg, int[] byteReceived) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.receiveMessage(msg, byteReceived);
                Log.d((String)TAG, (String)String.format("recvMsg Len=%d Msg=%s Hex=%02x%02x%02x", byteReceived[0], msg, msg[0], msg[1], msg[2]));
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean flushMsg() {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.flushMessages();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    boolean launchM2OSShortcut(byte[] shortcut) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.launchM2OSShortcut(shortcut);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public boolean isCompanionConnected() {
        boolean bRet = false;
        if (this.mPclService != null) {
            byte[] result = new byte[1];
            try {
                if (this.mPclService.serverStatus(result) && result[0] == 16) {
                    bRet = true;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return bRet;
    }

    private void initStateReceiver() {
        if (this.m_StateReceiver == null) {
            this.m_StateReceiver = new StateReceiver(this);
            IntentFilter intentfilter = new IntentFilter("com.ingenico.pclservice.intent.action.STATE_CHANGED");
            this.registerReceiver(this.m_StateReceiver, intentfilter);
        }
    }

    private void releaseStateReceiver() {
        if (this.m_StateReceiver != null) {
            this.unregisterReceiver(this.m_StateReceiver);
            this.m_StateReceiver = null;
        }
    }

    private class StateReceiver
    extends BroadcastReceiver {
        private IngenicoCommon ViewOwner = null;

        @SuppressLint(value={"UseValueOf"})
        public void onReceive(Context context, Intent intent) {
            String state = intent.getStringExtra("state");
            Log.d((String)IngenicoCommon.TAG, (String)String.format("receiver: State %s", state));
            this.ViewOwner.onStateChanged(state);
        }

        StateReceiver(IngenicoCommon receiver) {
            this.ViewOwner = receiver;
        }
    }

    private class BarCodeReceiver
    extends BroadcastReceiver {
        private IngenicoCommon ViewOwner = null;

        @SuppressLint(value={"UseValueOf"})
        public void onReceive(Context context, Intent intent) {
            byte[] abyte0 = intent.getByteArrayExtra("barcode");
            String BarCodeStr = new String(abyte0);
            this.ViewOwner.onBarCodeReceived(BarCodeStr);
        }

        BarCodeReceiver(IngenicoCommon receiver) {
            this.ViewOwner = receiver;
        }
    }

    public class _SYSTEMTIME {
        public short wYear;
        public short wMonth;
        public short wDayOfWeek;
        public short wDay;
        public short wHour;
        public short wMinute;
        public short wSecond;
        public short wMilliseconds;
    }

    public class PclServiceConnection
    implements ServiceConnection {
        public void onServiceConnected(ComponentName className, IBinder boundService) {
            IngenicoCommon.this.mPclService = IPclService.Stub.asInterface(boundService);
            Log.d((String)IngenicoCommon.TAG, (String)"onServiceConnected");
            IngenicoCommon.this.onPclServiceConnected();
        }

        public void onServiceDisconnected(ComponentName className) {
            IngenicoCommon.this.mPclService = null;
            Log.d((String)IngenicoCommon.TAG, (String)"onServiceDisconnected");
        }
    }
}

