/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DevicesBL;

import android.app.IntentService;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.fujitsu.fcl.libFTP2076210R0_Android.FTPAndroidLib;
import java.util.Date;

public class RollPrinterService
extends IntentService {
    public static String CLASS_NAME = "CCSTPrinterService";
    private int result = 0;
    private Date lastMsgTime = null;
    public static final String MESSAGE_REQUEST = "message_request";
    public static final String MESSAGE_ID = "message_id";
    public static final String MESSAGE_RESPONSE = "message_response";
    public static final String MESSAGE_ORIGIN = "message_origin";
    public static final String MAC_ADDRESS = "mac_address";
    public static final String MESSAGE_CONTENT = "message_content";
    public static final String RESULT = "result";
    public static final String NOTIFICATION = "com.example.twolibs";
    public static final int REQUEST_NONE = -1;
    public static final int REQUEST_CONNECT = 20;
    public static final int REQUEST_STATUS = 21;
    public static final int REQUEST_PRINT = 22;
    public static final int REQUEST_CLOSE = 23;
    public static final int REQUEST_FAILED = -2;
    private static FTPAndroidLib ftpAndroidLib;
    static PrinterState iCCST;
    static long lastMessage;
    static String readMessage;
    static String printerResponse;
    static String macAddress;
    static boolean printerConnected;
    int activeListener = 1;
    static int msgNo;
    private final Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            String FUNC_NAME = "handleMessage";
            switch (msg.what) {
                case 0: {
                    printerResponse = "";
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "PRINTERDATA_STATUS", 0);
                    byte[] dataBuf = (byte[])msg.obj;
                    int dataLen = msg.arg1;
                    if ((dataBuf[1] & 8) != 0) {
                        printerResponse = printerResponse + "Offline\n";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "Offline", 0);
                    }
                    if ((dataBuf[2] & 1) != 0) {
                        printerResponse = printerResponse + "Low battery\n";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "Low battery", 0);
                    }
                    if ((dataBuf[2] & 4) != 0) {
                        printerResponse = printerResponse + "Cover open\n";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "Cover open", 0);
                    }
                    if ((dataBuf[3] & 4) != 0) {
                        printerResponse = printerResponse + "No paper\n";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "No paper", 0);
                    }
                    if (printerResponse.equals("")) {
                        printerResponse = "Roll Printer OK";
                    }
                    RollPrinterService.this.result = -1;
                    int request = iCCST == PrinterState.PRINTING ? 22 : 21;
                    iCCST = PrinterState.READY;
                    RollPrinterService.this.publishResults(request, printerResponse, RollPrinterService.this.result);
                    break;
                }
                case 1: {
                    byte[] dataBuf = (byte[])msg.obj;
                    int dataLen = msg.arg1;
                    String data = String.format("%02X: ", msg.what);
                    String s = "";
                    for (int i = 0; i < dataLen; ++i) {
                        s = String.format("%02X ", dataBuf[i]);
                        data = data + s;
                    }
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "Firmware " + s, 0);
                    break;
                }
                case 2: {
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "PRINTERDATA_SENSOR", 0);
                    break;
                }
                case 3: {
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "PRINTERDATA_REGISTRABLEAREA", 0);
                    break;
                }
                default: {
                    TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleMessage", TraceHandler.Category.EXIT, "Message ", 0);
                }
            }
        }
    };

    public RollPrinterService() {
        super("RollPrinterService");
    }

    protected void onHandleIntent(Intent intent) {
        String FUNC_NAME = "onHandleIntent";
        ftpAndroidLib = FTPAndroidLib.getInstance();
        int request = intent.getIntExtra(MESSAGE_REQUEST, -1);
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onHandleIntent", TraceHandler.Category.ENTRY, "Service called " + request + "(" + ++msgNo + ")", 0);
        switch (request) {
            case 20: {
                String requestedMac = intent.getStringExtra(MAC_ADDRESS);
                this.openPrinter(request, macAddress);
                break;
            }
            case 21: {
                long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
                if (dteMessage - lastMessage > 2000L && iCCST == PrinterState.QUERY) {
                    iCCST = PrinterState.READY;
                    printerConnected = false;
                }
                if (!printerConnected) {
                    this.openPrinter(request, macAddress);
                }
                this.getPrinterStatus(request);
                break;
            }
            case 22: {
                this.result = 0;
                String msgContent = intent.getStringExtra(MESSAGE_CONTENT);
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onHandleIntent", TraceHandler.Category.ENTRY, "Print request printer:" + printerConnected, 0);
                if (!printerConnected) {
                    this.openPrinter(request, macAddress);
                }
                this.printCharacterString(request, this.xlate(msgContent));
                ftpAndroidLib.linefeedPaper(6);
                break;
            }
            case 23: {
                this.result = -1;
                this.publishResults(request, "Closing down", this.result);
                this.closePrinter(this.result);
                this.stopSelf();
                break;
            }
            case -2: {
                this.result = 0;
                String msgError = intent.getStringExtra(MESSAGE_CONTENT);
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onHandleIntent", TraceHandler.Category.ENTRY, "Not proper request", 0);
                this.publishResults(request, msgError, this.result);
                break;
            }
            default: {
                this.result = 0;
                this.publishResults(request, "No request", this.result);
            }
        }
    }

    private String xlate(String asciiString) {
        String test = asciiString.replace("\u00a3", "");
        return test;
    }

    private void publishResults(int request, String message, int result) {
        String FUNC_NAME = "publishResults";
        Intent intent = new Intent(NOTIFICATION);
        intent.putExtra(MESSAGE_REQUEST, request);
        intent.putExtra(MESSAGE_ID, msgNo);
        intent.putExtra(MESSAGE_RESPONSE, message);
        intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);
        intent.putExtra(RESULT, result);
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "publishResults", TraceHandler.Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);
        this.sendBroadcast(intent);
    }

    public int openPrinter(int request, String macAddress) {
        String FUNC_NAME = "openPrinter";
        int iRet = 1;
        int model = 1;
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "openPrinter", TraceHandler.Category.ENTRY, "Request " + request + " Mac " + macAddress, 0);
        iRet = ftpAndroidLib.startPrinter(model, macAddress, this.handler);
        this.getPrinterStatus(request);
        return iRet;
    }

    public int closePrinter(int request) {
        String FUNC_NAME = "closePrinter";
        int iRet = 1;
        iRet = ftpAndroidLib.closePrinter();
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "closePrinter", TraceHandler.Category.ENTRY, "Request " + request, 0);
        this.getPrinterStatus(request);
        return iRet;
    }

    public void printCharacterString(int request, String str) {
        int iRet = 1;
        iRet = ftpAndroidLib.printCharacterString(str);
    }

    public void getPrinterStatus(int request) {
        String FUNC_NAME = "closePrinter";
        int iRet = 1;
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "closePrinter", TraceHandler.Category.ENTRY, "Request " + request, 0);
        iRet = ftpAndroidLib.getPrinterData(0);
    }

    public void startPage() {
        int iRet = 1;
        Rect rect = new Rect(0, 0, 383, 200);
        iRet = ftpAndroidLib.startPage(rect);
        Point point = new Point(0, 50);
        ftpAndroidLib.setAbsolutePosition(point);
        ftpAndroidLib.printCharacterString("Orientation_None\n");
        iRet = ftpAndroidLib.printPage(2);
        ftpAndroidLib.setOrientation(3);
        ftpAndroidLib.setAbsolutePosition(point);
        ftpAndroidLib.printCharacterString("Orientation_R90\n90\ufffd");
        iRet = ftpAndroidLib.printPage(2);
        ftpAndroidLib.setOrientation(2);
        ftpAndroidLib.setAbsolutePosition(point);
        ftpAndroidLib.printCharacterString("Orientation_180\n180\ufffd");
        iRet = ftpAndroidLib.printPage(2);
        ftpAndroidLib.setOrientation(1);
        ftpAndroidLib.setAbsolutePosition(point);
        ftpAndroidLib.printCharacterString("Orientation_L90\n90\ufffd");
        iRet = ftpAndroidLib.printPage(0);
    }

    private int mod(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }

    private int testLoad() {
        String filename = Environment.getExternalStorageDirectory() + "/com.example.twolibs/CCST_A-BW-Mono.png";
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        int widthDots = bitmap.getWidth();
        int heightDots = bitmap.getHeight();
        int rowWidth = 384;
        int dataLen = rowWidth / 8 * heightDots;
        boolean dataCompression = false;
        byte[] data = new byte[dataLen];
        int pixel = 0;
        int iByte = 0;
        int iBit = 0;
        byte iShifted = 0;
        for (int y = 0; y < heightDots; ++y) {
            for (int x = 0; x < widthDots; ++x) {
                pixel = bitmap.getPixel(x, y);
                iByte = y * rowWidth / 8 + x / 8;
                iBit = this.mod(x, 8);
                iShifted = (byte)(1 >> iBit);
                if (pixel == -1) continue;
                data[iByte] = (byte)(data[iByte] & iShifted);
            }
        }
        int iRet = ftpAndroidLib.printBitimage(data, dataLen, rowWidth, heightDots, dataCompression);
        return 0;
    }

    private int testLoadImage() {
        String filename = Environment.getExternalStorageDirectory() + "/com.example.twolibs/Sample 2.png";
        Bitmap bitmap = BitmapFactory.decodeFile((String)filename);
        int dithering = 1;
        int widthDots = 384;
        int heightDots = 0;
        int iRet = 0;
        iRet = ftpAndroidLib.printPicture(bitmap, dithering, widthDots, heightDots);
        String receipt = "ARRIVA Trains Wales \n\nANYTIME DAY TC        \ufffd53.70\n  BASINGSTOKE \n  - LONDON ZONES 1-6\n  Valid on 24/04/2015\n  1 Adult    Ticket no:175  \n                    ========\nBALANCE DUE           \ufffd53.70\n\nCash                  \ufffd73.70\n\n\n 9020T02W31M1023 0001 1912\n Operator 207 13:26 24-04-15\n\n   * 11377329862121654 *\n";
        iRet = ftpAndroidLib.printCharacterString(receipt);
        return 0;
    }

    public void printBitimage() {
        int iRet = 1;
        int widthDots = 384;
        int heightDots = 64;
        int dataLen = widthDots / 8 * heightDots;
        boolean dataCompression = false;
        byte[] data = new byte[dataLen];
        int i = 0;
        for (int k = 0; k < heightDots; ++k) {
            for (int j = 0; j < widthDots / 8; j += 2) {
                if (k % 16 < 8) {
                    data[i] = -1;
                    data[i + 1] = 0;
                } else {
                    data[i] = 0;
                    data[i + 1] = -1;
                }
                i += 2;
            }
        }
        iRet = ftpAndroidLib.printBitimage(data, dataLen, widthDots, heightDots, dataCompression);
        this.testLoadImage();
    }

    static {
        iCCST = PrinterState.NOBLUETOOTH;
        lastMessage = 0L;
        readMessage = "";
        printerResponse = "";
        macAddress = "00:0B:5D:37:BB:07";
        printerConnected = false;
        msgNo = 0;
    }

    public static enum PrinterState {
        NOBLUETOOTH,
        BLUETOOTH,
        NOTREADY,
        READY,
        QUERY,
        PRINTING;

    }
}

