/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableBL;

import com.example.twolibs.TimeTableBL.clsCateringCodesHasBuffet;
import com.example.twolibs.TimeTableBL.clsCateringCodesHasRestaurant;
import com.example.twolibs.TimeTableBL.clsUtilities;
import java.io.Serializable;

public class clsCateringCodes
implements Serializable {
    private static final long serialVersionUID = 798881879356042320L;
    private static final String CATERCODE_COLDBUFFET = "C";
    private static final String CATERCODE_HOTBUFFET = "H";
    private static final String CATERCODE_WHEELCHAIR = "P";
    private static final String CATERCODE_RESTAURANT = "R";
    private static final String CATERCODE_RESTR1STONLY = "F";
    private static final String CATERCODE_SILVERSTD = "S";
    private static final String CATERCODE_TROLLEY = "T";
    private static final String CATERCODE_MEALINFIRST = "M";
    private String cateringCodes = "";

    public clsCateringCodesHasBuffet hasBuffet() {
        clsCateringCodesHasBuffet ret = new clsCateringCodesHasBuffet();
        if (this.cateringCodes.indexOf(CATERCODE_HOTBUFFET) > -1) {
            ret.hasBuffet = true;
            ret.isHotBuffet = true;
        } else {
            ret.isHotBuffet = false;
            ret.hasBuffet = this.cateringCodes.indexOf(CATERCODE_COLDBUFFET) > -1;
        }
        return ret;
    }

    public boolean containsCateringCode(String caterCode) {
        return this.cateringCodes.indexOf(caterCode) > -1;
    }

    public clsCateringCodesHasRestaurant hasRestaurant() {
        clsCateringCodesHasRestaurant ret = new clsCateringCodesHasRestaurant();
        if (this.cateringCodes.indexOf(CATERCODE_RESTR1STONLY) > -1) {
            ret.hasRestaurant = true;
            ret.isFirstClassRestaurant = true;
        } else {
            ret.isFirstClassRestaurant = false;
            ret.hasRestaurant = this.cateringCodes.indexOf(CATERCODE_RESTAURANT) > -1;
        }
        return ret;
    }

    public boolean hasSilverStd() {
        return this.cateringCodes.indexOf(CATERCODE_SILVERSTD) > -1;
    }

    public boolean hasTrolley() {
        return this.cateringCodes.indexOf(CATERCODE_TROLLEY) > -1;
    }

    public boolean hasWheelchairCaterCode() {
        return this.cateringCodes.indexOf(CATERCODE_WHEELCHAIR) > -1;
    }

    public void setBaseCodes(String p_sCodes) {
        this.cateringCodes = p_sCodes == null ? "" : p_sCodes.trim();
    }

    public String getTHOCodes() {
        if (this.cateringCodes.length() == 0) {
            return null;
        }
        String THOCodes = (String)clsUtilities.deepClone(this.cateringCodes);
        if (THOCodes.length() > 4) {
            THOCodes = THOCodes.substring(0, 5);
        }
        return THOCodes;
    }

    public String getCateringFacilitiesString() {
        String cateringFacilitiesString = "";
        boolean hadPrevious = false;
        if (this.cateringCodes != null) {
            clsCateringCodesHasRestaurant hasRestaurant = this.hasRestaurant();
            clsCateringCodesHasBuffet hasBuffet = this.hasBuffet();
            if (hasRestaurant.isFirstClassRestaurant) {
                cateringFacilitiesString = cateringFacilitiesString + "Restaurant First Class Only";
                hadPrevious = true;
            } else if (hasRestaurant.hasRestaurant) {
                cateringFacilitiesString = cateringFacilitiesString + "Restaurant";
                hadPrevious = true;
            }
            if (this.cateringCodes.indexOf(CATERCODE_MEALINFIRST) > -1) {
                if (hadPrevious) {
                    cateringFacilitiesString = cateringFacilitiesString + ", ";
                } else {
                    hadPrevious = true;
                }
                cateringFacilitiesString = cateringFacilitiesString + "Meal included for 1st class passengers";
            }
            if (hasBuffet.hasBuffet) {
                if (hadPrevious) {
                    cateringFacilitiesString = cateringFacilitiesString + ", ";
                } else {
                    hadPrevious = true;
                }
                cateringFacilitiesString = hasBuffet.isHotBuffet ? cateringFacilitiesString + "Hot Buffet" : cateringFacilitiesString + "Cold Buffet";
            }
            if (this.cateringCodes.indexOf(CATERCODE_TROLLEY) > -1) {
                if (hadPrevious) {
                    cateringFacilitiesString = cateringFacilitiesString + ", ";
                }
                cateringFacilitiesString = cateringFacilitiesString + "Trolley";
            }
        }
        return cateringFacilitiesString;
    }

    public String toString() {
        return "" + this.cateringCodes;
    }
}

