/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DataTransferBL;

import android.os.Environment;
import com.example.twolibs.DataTransferBL.DataDownLoadHelper;
import com.example.twolibs.DataTransferBL.DataTransferFile;
import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class DataTransferManager
extends GenericManager {
    private static String CLASS_NAME = "DataTransferManager";
    private static boolean refreshRequired = true;
    public static HashMapX<String, DataTransferGroup> allDownLoadDataGroups = new HashMapX();
    public static HashMapX<String, DataTransferFile> allFiles = new HashMapX();
    public static String DATADOWNLOADSERVICE = "DATADOWNLOADSERVICE";
    public static String DATAGROUPUPDATED = "DATAGROUPUPDATED";

    public static GenericManager.DomainStatusResponse checkStatus() {
        String FUNC_NAME = "checkStatus";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "checkStatus", TraceHandler.Category.ENTRY, "", 0);
        GenericManager.DomainStatusResponse resp = new GenericManager.DomainStatusResponse();
        resp.status = GenericManager.MenuState.NORMAL;
        resp.shortDescrition = "Sync\nData";
        for (DataTransferGroup dataGroup : allDownLoadDataGroups.values()) {
            if (dataGroup.transferStatus <= resp.status.ordinal()) continue;
            resp.status = GenericManager.MenuState.NORMAL;
            resp.shortDescrition = "Duty";
        }
        return resp;
    }

    public static void handleEvent(String pSource, String pEventType, String pData) {
        String FUNC_NAME = "handleEvent";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "handleEvent", TraceHandler.Category.ENTRY, "", 0);
        if (pSource.equals(DATADOWNLOADSERVICE) && pSource.equals(DATAGROUPUPDATED)) {
            refreshRequired = true;
            DataTransferManager.refreshdata();
        }
    }

    public static void refreshdata() {
        String FUNC_NAME = "refreshdata";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "refreshdata", TraceHandler.Category.ENTRY, "", 0);
        if (refreshRequired) {
            DataTransferManager.getProgramPath();
            allDownLoadDataGroups = DataDownLoadHelper.doLoadTest();
            allFiles = DataDownLoadHelper.doLoadDataFilesXML(allDownLoadDataGroups);
            refreshRequired = false;
        }
    }

    public static String getProgramPath() {
        String root = Environment.getExternalStorageDirectory() + "/com.example.twolibs/";
        File folder = new File(root);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return root;
    }

    public static String getRootPath() {
        String root = Environment.getExternalStorageDirectory() + "/DataSync/";
        File folder = new File(root);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return root;
    }

    public static String getFileName(FileType pFileType) {
        String root = DataTransferManager.getRootPath();
        switch (pFileType) {
            case DATADOWNLOADSTATE: {
                return root + "DownloadConfig.xml";
            }
            case CCSTFORMATS: {
                return Environment.getExternalStorageDirectory() + "/com.example.twolibs/CCSTDefinition.txt";
            }
            case DUTIES: {
                return Environment.getExternalStorageDirectory() + "/com.example.twolibs/duty.xml";
            }
            case DUTYTASKTYPES: {
                return Environment.getExternalStorageDirectory() + "/com.example.twolibs/dutytasktypes.xml";
            }
            case TRACELOG: {
                return Environment.getExternalStorageDirectory() + "/com.example.twolibs/trace.txt";
            }
        }
        return "";
    }

    public static String getDownloadPath(String pDataGroupName) {
        DataTransferGroup dataTransferGroup = (DataTransferGroup)allDownLoadDataGroups.get(pDataGroupName);
        if (dataTransferGroup == null) {
            return "";
        }
        String root = DataTransferManager.getRootPath();
        String dataGroupPath = root + dataTransferGroup.dataGroupFolder + "/" + dataTransferGroup.currentSet + "/";
        return dataGroupPath;
    }

    public static String getDownloadConfig(String pDataGroupName) {
        String root = DataTransferManager.getDownloadPath(pDataGroupName);
        String dataGroupPath = root + "DataGroupConfig.xml";
        return dataGroupPath;
    }

    public static STDDocumentResponse getDocument(FileType pFileType) {
        String FUNC_NAME = "getDocument";
        STDDocumentResponse result = new STDDocumentResponse();
        String filename = DataTransferManager.getFileName(pFileType);
        File file = new File(filename);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            result.doc = db.parse(file);
            result.doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            result.result = GenericManager.Response.Error;
            result.trace = "Exception = " + pFileType.name() + " " + filename + e;
            result.extra = "Document error ";
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "getDocument", TraceHandler.Category.EXIT, result.trace, 0);
            return result;
        }
        result.result = GenericManager.Response.OK;
        result.trace = "Document loaded" + result.doc.getLocalName();
        result.extra = "OK";
        return result;
    }

    public static STDDocumentResponse getDocumentRaw(String pFilename) {
        String FUNC_NAME = "getDocumentRaw";
        STDDocumentResponse result = new STDDocumentResponse();
        File file = new File(pFilename);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            result.doc = db.parse(file);
            result.doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            result.result = GenericManager.Response.Error;
            result.trace = "Exception = " + pFilename + e;
            result.extra = "Document error ";
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "getDocumentRaw", TraceHandler.Category.EXIT, result.trace, 0);
            return result;
        }
        result.result = GenericManager.Response.OK;
        result.trace = "Document loaded" + result.doc.getLocalName();
        result.extra = "OK";
        return result;
    }

    public static STDContentResponse getContent(FileType pFileType) {
        String FUNC_NAME = "getContent";
        STDContentResponse result = new STDContentResponse();
        String filename = DataTransferManager.getFileName(pFileType);
        File file = new File(filename);
        if (!file.exists()) {
            result.result = GenericManager.Response.Error;
            result.trace = "File not found = " + pFileType.name() + " " + filename;
            result.extra = "File missing ";
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "getContent", TraceHandler.Category.EXIT, result.trace, 0);
            return result;
        }
        byte[] fileContent = new byte[(int)file.length()];
        try {
            FileInputStream fin = new FileInputStream(filename);
            fin.read(fileContent);
            fin.close();
        }
        catch (Exception e) {
            result.result = GenericManager.Response.Error;
            result.trace = "Exception = " + pFileType.name() + " " + filename + e;
            result.extra = "File error ";
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "getContent", TraceHandler.Category.EXIT, result.trace, 0);
            return result;
        }
        result.result = GenericManager.Response.OK;
        result.trace = "Read " + fileContent.length;
        result.extra = "OK";
        result.content = fileContent;
        return result;
    }

    public static ArrayList<DataTransferGroup> getTransfers() {
        String FUNC_NAME = "getTransfers";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "getTransfers", TraceHandler.Category.ENTRY, "", 0);
        ArrayList<DataTransferGroup> dataGroupList = new ArrayList<DataTransferGroup>();
        for (DataTransferGroup domain : allDownLoadDataGroups.values()) {
            dataGroupList.add(domain);
        }
        return dataGroupList;
    }

    public static class STDContentResponse
    extends GenericManager.STDResponse {
        public byte[] content = new byte[0];
    }

    public static class STDDocumentResponse
    extends GenericManager.STDResponse {
        public Document doc = null;
    }

    public static enum FileType {
        CCSTFORMATS,
        DUTIES,
        DUTYTASKTYPES,
        DATADOWNLOADSTATE,
        TRACELOG;

    }
}

