/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FulfilmentBL;

import com.example.twolibs.AppContext;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.CCSTFulfilment;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SessionBL.SDCIData;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;
import java.util.Date;

public class FulfilmentManager {
    private static String CLASS_NAME = "FulfilmentManager";
    private static boolean refreshRequired = true;
    private static String DataDomain = "FulfilmentData";
    private static boolean ready = false;
    private static CCSTFulfilment ccstFulf = new CCSTFulfilment();

    public static void dataChanged(String pDataDomain) {
        if (pDataDomain.equals(DataDomain)) {
            refreshRequired = true;
        }
    }

    public static void refreshdata() {
        String FUNC_NAME = "refreshdata";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "refreshdata", TraceHandler.Category.ENTRY, "", 0);
        if (refreshRequired) {
            CCSTFulfilment.STDResponse resp = ccstFulf.doGenPectabs();
            ready = resp.result == CCSTFulfilment.Response.OK;
            refreshRequired = false;
        }
    }

    public static AppContext.DomainStatusResponse checkStatus() {
        String FUNC_NAME = "checkStatus";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "checkStatus", TraceHandler.Category.ENTRY, "", 0);
        AppContext.DomainStatusResponse resp = new AppContext.DomainStatusResponse();
        if (ready) {
            resp.status = AppContext.MenuState.NORMAL;
            resp.shortDescrition = "Fulfilment";
        } else {
            resp.status = AppContext.MenuState.NOTIFY;
            resp.shortDescrition = "Fulfilment\n(Data)";
        }
        return resp;
    }

    public static STDCreateCouponsResponse createFulfilmentCoupons(AppContext bb, Basket pBasket) {
        String FUNC_NAME = "createFulfilmentCoupons";
        STDCreateCouponsResponse resp = new STDCreateCouponsResponse();
        resp.result = Response.OK;
        String methodOfPayment = FulfilmentManager.determineMOP(pBasket);
        Date dteSaleDate = DataConvert.getNow();
        int intTicketNumber = 1000;
        for (BasketSupport bs : pBasket.basketProducts) {
            if (bs.itemType != BasketSupport.ItemType.FARE) continue;
            SDCIData sd = new SDCIData();
            sd.MachineNumber = 1120;
            sd.SellingNLC = "5520";
            sd.WindowNumber = 31;
            sd.saleTimestamp = dteSaleDate;
            sd.intTicketNumber = ++intTicketNumber;
            resp.sdciRecords.add(sd);
            CCSTCoupon coupon = FulfilmentManager.createCoupon(bb, bs, sd, methodOfPayment);
            if (bs.ticket.getFa_SingleOrReturn().equals("S")) {
                coupon.strTravelDirection = "SGL";
                coupon.blnReverseFlow = false;
                resp.ccstCoupons.add(coupon);
                continue;
            }
            if (bs.ticket.getFa_SingleOrReturn().equals("R")) {
                coupon.strTravelDirection = "OUT";
                coupon.blnReverseFlow = false;
                resp.ccstCoupons.add(coupon);
                coupon = FulfilmentManager.createCoupon(bb, bs, sd, methodOfPayment);
                coupon.strTravelDirection = "RET";
                coupon.blnReverseFlow = true;
                resp.ccstCoupons.add(coupon);
                continue;
            }
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Unhandled " + bs.ticket.getFa_SingleOrReturn(), 0);
            resp.result = Response.Error;
        }
        String fieldList = "";
        String sFieldValueList = "";
        for (CCSTCoupon coupon : resp.ccstCoupons) {
            CCSTFulfilment.STDResponse formatResp = ccstFulf.doGetFieldIds(coupon.couponFormat);
            if (formatResp.result == CCSTFulfilment.Response.OK) {
                fieldList = formatResp.extra;
                formatResp = ccstFulf.doGetFieldData(fieldList, coupon);
                sFieldValueList = formatResp.extra;
                if (formatResp.result == CCSTFulfilment.Response.OK) {
                    formatResp = ccstFulf.doGetPrintData(coupon.couponFormat, sFieldValueList);
                    if (formatResp.result == CCSTFulfilment.Response.OK) {
                        coupon.strPrintMessage = formatResp.extra;
                        continue;
                    }
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format msg " + coupon.couponFormat, 0);
                    resp.result = Response.Error;
                    continue;
                }
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format data " + coupon.couponFormat, 0);
                resp.result = Response.Error;
                continue;
            }
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format " + coupon.couponFormat, 0);
            resp.result = Response.Error;
        }
        return resp;
    }

    public static STDCreateCouponsResponse createTestCoupon() {
        String FUNC_NAME = "createFulfilmentCoupons";
        STDCreateCouponsResponse resp = new STDCreateCouponsResponse();
        resp.result = Response.OK;
        String methodOfPayment = "M";
        Date dteSaleDate = DataConvert.getNow();
        int intTicketNumber = 1000;
        SDCIData sd = new SDCIData();
        sd.MachineNumber = 1120;
        sd.SellingNLC = "5520";
        sd.WindowNumber = 31;
        sd.saleTimestamp = dteSaleDate;
        sd.intTicketNumber = ++intTicketNumber;
        resp.sdciRecords.add(sd);
        CCSTCoupon coupon = new CCSTCoupon();
        resp.ccstCoupons.add(coupon);
        coupon.sdci = sd;
        coupon.couponFormat = "P01";
        coupon.bsItem = new BasketSupport();
        coupon.bsItem.itemType = BasketSupport.ItemType.COMMENT;
        String fieldList = "";
        String sFieldValueList = "";
        CCSTFulfilment.STDResponse formatResp = ccstFulf.doGetFieldIds(coupon.couponFormat);
        if (formatResp.result == CCSTFulfilment.Response.OK) {
            fieldList = formatResp.extra;
            formatResp = ccstFulf.doGetFieldData(fieldList, coupon);
            sFieldValueList = formatResp.extra;
            if (formatResp.result == CCSTFulfilment.Response.OK) {
                formatResp = ccstFulf.doGetPrintData(coupon.couponFormat, sFieldValueList);
                if (formatResp.result == CCSTFulfilment.Response.OK) {
                    coupon.strPrintMessage = formatResp.extra;
                } else {
                    TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format msg " + coupon.couponFormat, 0);
                    resp.result = Response.Error;
                }
            } else {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format data " + coupon.couponFormat, 0);
                resp.result = Response.Error;
            }
        } else {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "createFulfilmentCoupons", TraceHandler.Category.ERROREXIT, "Can't format " + coupon.couponFormat, 0);
            resp.result = Response.Error;
        }
        return resp;
    }

    private static String determineMOP(Basket basket) {
        String sMOP = "";
        for (BasketSupport bs : basket.basketTenders) {
            if (!sMOP.contains(bs.tender.methodOfPayment())) continue;
            sMOP = sMOP + bs.tender.methodOfPayment();
        }
        if (sMOP.contains("X")) {
            return "X";
        }
        return sMOP;
    }

    private static CCSTCoupon createCoupon(AppContext bb, BasketSupport bs, SDCIData sd, String methodOfPayment) {
        CCSTCoupon coupon = new CCSTCoupon();
        coupon.sdci = sd;
        coupon.bsItem = bs;
        coupon.SetupFare(bb);
        coupon.strCouponMethodOfPayment = methodOfPayment;
        coupon.couponFormat = coupon.tkt.getTd_CouponFormat();
        coupon.intNumAdults = bs.ticket.getFa_NumAdults();
        coupon.intNumChildren = bs.ticket.getFa_NumChildren();
        coupon.intNumCoupons = 0;
        coupon.dlbCouponValue = bs.ticket.getFa_TotalFareS();
        return coupon;
    }

    public static class STDCreateCouponsResponse
    extends STDResponse {
        public ArrayList<SDCIData> sdciRecords = new ArrayList();
        public ArrayList<CCSTCoupon> ccstCoupons = new ArrayList();
    }

    public static class STDResponse {
        public Response result = Response.OK;
        public String extra = "";
        public String trace = "";
    }

    public static enum Response {
        OK,
        Error;

    }
}

