/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SaleGUI;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.FulfilmentGUI.CCSTPrinting;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleGUI.BasketListAdaptor;
import com.example.twolibs.SaleGUI.TenderCash;
import com.example.twolibs.SaleGUI.TenderTypes;
import java.util.ArrayList;

public class BasketList
extends ListActivity {
    int iCurrentMenu = -1;
    int iCurrentSelection = -1;
    public static final int REQUEST_CARD = 1;
    public static final int REQUEST_CASH = 2;
    public static final int REQUEST_PRINT = 3;
    ArrayList<BasketSupport> itemList = new ArrayList();
    BasketListAdaptor adapter;
    ListView listview;

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    public void onCreate(Bundle savedInstanceState) {
        String nextAction;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_basket);
        this.setTitle(" Basket");
        this.listview = (ListView)this.findViewById(16908298);
        final AppContext bb = (AppContext)this.getApplicationContext();
        bb.basket.refreshBasket(bb);
        this.itemList = bb.basket.basketContents;
        this.adapter = new BasketListAdaptor((Activity)this, this.itemList, bb);
        this.setListAdapter((ListAdapter)this.adapter);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    parent.getChildAt(j).setBackgroundColor(0);
                }
                if (position == BasketList.this.iCurrentSelection) {
                    BasketList.this.setMenu(0);
                    bb.selFare = null;
                    BasketList.this.iCurrentSelection = -1;
                } else {
                    BasketList.this.setMenu(1);
                    BasketList.this.iCurrentSelection = position;
                    view.setBackgroundColor(BasketList.this.JMgetColor(R.color.selection_background, BasketList.this.getTheme()));
                }
            }
        });
        this.setMenu(0);
        Intent intent = this.getIntent();
        if (intent != null && (nextAction = intent.getStringExtra("nextAction")) != null) {
            if (nextAction.equals("cash")) {
                Intent nextScreen = new Intent(this.getApplicationContext(), TenderCash.class);
                nextScreen.putExtra("nextAction", "");
                this.startActivityForResult(nextScreen, 1);
            } else if (nextAction.equals("card")) {
                // empty if block
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public Intent getParentActivityIntent() {
        Intent newIntent = new Intent(this.getApplicationContext(), FaresCriteria.class);
        return newIntent;
    }

    private void setMenu(int iMenu) {
        if (iMenu != this.iCurrentMenu) {
            LinearLayout layFormMenu = (LinearLayout)this.findViewById(R.id.layFormMenu);
            layFormMenu.removeAllViews();
            LayoutInflater inflater = this.getLayoutInflater();
            if (iMenu == 0) {
                layFormMenu.addView(inflater.inflate(R.layout.basket_menu0, null));
                Button cmdPay = (Button)this.findViewById(R.id.cmdPay);
                cmdPay.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent nextScreen = new Intent(BasketList.this.getApplicationContext(), TenderTypes.class);
                        nextScreen.putExtra("nextAction", "");
                        BasketList.this.startActivityForResult(nextScreen, 1);
                    }
                });
                Button cmdClear = (Button)this.findViewById(R.id.cmdClear);
                cmdClear.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)BasketList.this.getApplicationContext();
                        bb.basket.basketContents.clear();
                        bb.basket.basketProducts.clear();
                        bb.basket.basketTenders.clear();
                        bb.basket.refreshBasket(bb);
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        BasketList.this.setResult(-1, returnIntent);
                        BasketList.this.finish();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        BasketList.this.setResult(-1, returnIntent);
                        BasketList.this.finish();
                    }
                });
            } else {
                layFormMenu.addView(inflater.inflate(R.layout.basket_menu1, null));
            }
            this.iCurrentMenu = iMenu;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        AppContext bb = (AppContext)this.getApplicationContext();
        if ((requestCode == 1 || requestCode == 2) && resultCode == -1) {
            this.itemList = bb.basket.basketContents;
            if (bb.basket.balanceDue == 0 && bb.basket.basketContents.size() > 0) {
                Intent nextScreen = new Intent(this.getApplicationContext(), CCSTPrinting.class);
                nextScreen.putExtra("nextAction", "print");
                this.startActivityForResult(nextScreen, 3);
            } else {
                this.adapter = new BasketListAdaptor((Activity)this, this.itemList, bb);
                this.setListAdapter((ListAdapter)this.adapter);
            }
        }
        if (requestCode == 3) {
            for (BasketSupport bs : bb.basket.basketProducts) {
                if (bs.itemType != BasketSupport.ItemType.FARE) continue;
                bb.fareManager.addHistoricFare(bs.ticket);
            }
            bb.basket.basketContents.clear();
            bb.basket.basketProducts.clear();
            bb.basket.basketTenders.clear();
            bb.basket.refreshBasket(bb);
            this.adapter = new BasketListAdaptor((Activity)this, this.itemList, bb);
            this.setListAdapter((ListAdapter)this.adapter);
        }
    }
}

