/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableGUI;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableGUI.LegDetails;
import java.util.List;

public class JourneyListAdaptor
extends ArrayAdapter<TTJourney> {
    private final Activity context;
    private final List<TTJourney> jnyList;
    private final AppContext bb;
    private View.OnClickListener mOnDetailClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            LinearLayout button_container = (LinearLayout)v.getParent();
            LinearLayout column_container = (LinearLayout)button_container.getParent();
            RelativeLayout row_container = (RelativeLayout)column_container.getParent();
            ListView parent = (ListView)row_container.getParent();
            int position = parent.getPositionForView(v);
            if (position != -1) {
                TTJourney jny;
                ((JourneyListAdaptor)JourneyListAdaptor.this).bb.selJourney = jny = (TTJourney)JourneyListAdaptor.this.jnyList.get(position);
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    parent.getChildAt(j).setBackgroundColor(0);
                }
                ((View)v.getParent()).setBackgroundColor(-3355444);
                Log.e((String)"XXX", (String)("Title clicked" + position));
                Intent nextScreen = new Intent((Context)JourneyListAdaptor.this.context, LegDetails.class);
                nextScreen.putExtra("direction", "from");
                JourneyListAdaptor.this.context.startActivityForResult(nextScreen, 1);
            }
        }
    };

    public JourneyListAdaptor(Activity context, List<TTJourney> jnyList, AppContext bb) {
        super((Context)context, R.layout.journey_summary, jnyList);
        this.context = context;
        this.jnyList = jnyList;
        this.bb = bb;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View rowView = convertView;
        if (rowView == null) {
            LayoutInflater inflater = this.context.getLayoutInflater();
            rowView = inflater.inflate(R.layout.journey_summary, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.txtDepartTime = (TextView)rowView.findViewById(R.id.txtDepartTime);
            viewHolder.txtOrigin = (TextView)rowView.findViewById(R.id.txtOrigin);
            viewHolder.txtArriveTime = (TextView)rowView.findViewById(R.id.txtArriveTime);
            viewHolder.txtDestination = (TextView)rowView.findViewById(R.id.txtDestination);
            viewHolder.txtNotes = (TextView)rowView.findViewById(R.id.txtNotes);
            viewHolder.txtLegs = (TextView)rowView.findViewById(R.id.txtLegs);
            viewHolder.cmdDetail = (Button)rowView.findViewById(R.id.cmdDetail);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        rowView.setBackgroundColor(0);
        holder.cmdDetail.setOnClickListener(this.mOnDetailClickListener);
        holder.position = position;
        TTJourney j = this.jnyList.get(position);
        TTLeg l = j.getJy_legs().get(0);
        holder.txtDepartTime.setText((CharSequence)l.getLeg_departsTime());
        String crsCode = l.getLeg_origin();
        Location loc = Location.getLocationByCRS(crsCode);
        String txtDescription = loc != null ? loc.getDescription() : crsCode;
        holder.txtOrigin.setText((CharSequence)txtDescription);
        l = j.getJy_legs().get(j.getJy_legs().size() - 1);
        holder.txtArriveTime.setText((CharSequence)l.getLeg_arrivesTime());
        crsCode = l.getLeg_destination();
        loc = Location.getLocationByCRS(crsCode);
        txtDescription = loc != null ? loc.getDescription() : crsCode;
        holder.txtDestination.setText((CharSequence)txtDescription);
        String txtNotes = "";
        if (j.getJy_overtakentrainlevel() > 0) {
            txtNotes = " Overtaken";
        }
        holder.txtNotes.setText((CharSequence)txtNotes);
        String txtChanges = j.getJy_numlegs() == 1 ? " Direct" : (j.getJy_numlegs() == 2 ? " One change" : " " + (j.getJy_numlegs() - 1) + " changes");
        holder.txtLegs.setText((CharSequence)txtChanges);
        return rowView;
    }

    static class ViewHolder {
        public TextView txtDepartTime;
        public TextView txtOrigin;
        public TextView txtArriveTime;
        public TextView txtDestination;
        public TextView txtNotes;
        public TextView txtLegs;
        public Button cmdDetail;
        public int position;

        ViewHolder() {
        }
    }
}

