/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableGUI;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableBL.TTStop;
import com.example.twolibs.TimeTableGUI.JourneySupport;
import java.util.ArrayList;

public class LegListAdaptor
extends ArrayAdapter<JourneySupport> {
    private final Activity context;
    private final ArrayList<JourneySupport> legList;
    private final AppContext bb;

    public LegListAdaptor(Activity context, ArrayList<JourneySupport> legList, AppContext bb) {
        super((Context)context, R.layout.leg_summary, legList);
        this.context = context;
        this.legList = legList;
        this.bb = bb;
    }

    int JMgetColor(int Color2, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.context.getResources().getColor(Color2, TH);
        }
        return this.context.getResources().getColor(Color2);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Location loc;
        View rowView = convertView;
        if (rowView == null) {
            LayoutInflater inflater = this.context.getLayoutInflater();
            rowView = inflater.inflate(R.layout.leg_summary, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.txtDepartTime = (TextView)rowView.findViewById(R.id.txtDepartTime);
            viewHolder.txtArriveDesc = (TextView)rowView.findViewById(R.id.txtArriveDesc);
            viewHolder.txtDepartDesc = (TextView)rowView.findViewById(R.id.txtDepartDesc);
            viewHolder.txtLocation = (TextView)rowView.findViewById(R.id.txtLocation);
            viewHolder.txtArriveTime = (TextView)rowView.findViewById(R.id.txtArriveTime);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        holder.position = position;
        JourneySupport js = this.legList.get(position);
        if (js.eventType < 2) {
            TTLeg l = js.leg;
            holder.txtDepartTime.setPadding(0, 0, 0, 0);
            if (js.eventType == 0) {
                holder.txtArriveDesc.setText((CharSequence)"");
                holder.txtDepartDesc.setText((CharSequence)"Depart: ");
                holder.txtDepartTime.setText((CharSequence)l.getLeg_departsTime());
                String crsCode = l.getLeg_origin();
                loc = Location.getLocationByCRS(crsCode);
                String txtLocation = loc != null ? loc.getDescription() : crsCode;
                holder.txtLocation.setText((CharSequence)txtLocation);
                holder.txtArriveTime.setText((CharSequence)"");
            } else {
                holder.txtArriveDesc.setText((CharSequence)"");
                holder.txtDepartDesc.setText((CharSequence)"Arrive: ");
                holder.txtDepartTime.setText((CharSequence)"");
                String crsCode = l.getLeg_destination();
                loc = Location.getLocationByCRS(crsCode);
                String txtLocation = loc != null ? loc.getDescription() : crsCode;
                holder.txtLocation.setText((CharSequence)txtLocation);
                holder.txtArriveTime.setText((CharSequence)l.getLeg_arrivesTime());
            }
        } else {
            TTStop s = js.stop;
            holder.txtArriveDesc.setText((CharSequence)"");
            holder.txtDepartDesc.setText((CharSequence)"");
            String strTime = s.getPse_arrives();
            strTime = strTime.subSequence(0, 2) + ":" + strTime.subSequence(2, 4);
            holder.txtDepartTime.setText((CharSequence)strTime);
            holder.txtDepartTime.setPadding(40, 0, 0, 0);
            holder.txtDepartTime.setTextColor(this.JMgetColor(R.color.fj_grey_2, this.context.getTheme()));
            String crsCode = s.getPse_station();
            loc = Location.getLocationByCRS(crsCode);
            String txtLocation = loc != null ? loc.getDescription() : crsCode;
            holder.txtLocation.setText((CharSequence)txtLocation);
            holder.txtLocation.setPadding(40, 0, 0, 0);
            holder.txtArriveTime.setText((CharSequence)"");
        }
        return rowView;
    }

    static class ViewHolder {
        public TextView txtDepartTime;
        public TextView txtArriveDesc;
        public TextView txtDepartDesc;
        public TextView txtLocation;
        public TextView txtArriveTime;
        public int position;

        ViewHolder() {
        }
    }
}

