/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DevicesGUI;

import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.DevicesBL.CCSTPrinterService;
import com.example.twolibs.DevicesBL.IngenicoCommon;
import com.example.twolibs.DevicesBL.RollPrinterService;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.R;
import com.ingenico.pclservice.IPclService;
import com.ingenico.pclservice.TransactionIn;
import com.ingenico.pclservice.TransactionOut;

public class DeviceSupport
extends IngenicoCommon {
    private Context activityContext;
    private BluetoothAdapter bluetoothAdapter;
    private static final int ENABLE_BT_REQUEST_CODE = 1;
    private final BroadcastReceiver receiverCCST = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String origin;
                int resultCode = bundle.getInt("result");
                String string2 = bundle.getString("message_response");
                if (string2 == null) {
                    string2 = "";
                }
                if ((origin = bundle.getString("message_origin")) == null) {
                    origin = "no origin";
                }
                Log.e((String)"DS", (String)("BC1 received " + origin));
                TextView tv = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                if (origin.equals(CCSTPrinterService.CLASS_NAME)) {
                    if (resultCode == -1) {
                        tv.setText((CharSequence)("CCST ok" + string2));
                        tv.setBackgroundColor(-16711936);
                        tv.setTextColor(-16777216);
                    } else {
                        tv.setText((CharSequence)("CCST failed " + resultCode + "\n" + string2));
                        tv.setBackgroundColor(-65536);
                        tv.setTextColor(-16777216);
                    }
                }
            }
        }
    };
    private final BroadcastReceiver receiverRoll = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String origin;
                int resultCode = bundle.getInt("result");
                String string2 = bundle.getString("message_response");
                if (string2 == null) {
                    string2 = "";
                }
                if ((origin = bundle.getString("message_origin")) == null) {
                    origin = "no origin";
                }
                Log.e((String)"DS", (String)("BC1 received " + origin));
                TextView tv = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                if (origin.equals(RollPrinterService.CLASS_NAME)) {
                    if (resultCode == -1) {
                        tv.setText((CharSequence)string2);
                        tv.setBackgroundColor(-16711936);
                        tv.setTextColor(-16777216);
                    } else {
                        tv.setText((CharSequence)("Roll failed " + resultCode + "\n" + string2));
                        tv.setBackgroundColor(-65536);
                        tv.setTextColor(-16777216);
                    }
                }
            }
        }
    };
    private final BroadcastReceiver refreshScreen = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String origin;
                int resultCode = bundle.getInt("result");
                String string2 = bundle.getString("message_response");
                if (string2 == null) {
                    string2 = "";
                }
                if ((origin = bundle.getString("message_origin")) == null) {
                    origin = "no origin";
                }
                Log.e((String)"DS", (String)("Screen refresh received " + origin));
                TextView tv = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                if (origin.equals(RollPrinterService.CLASS_NAME)) {
                    if (resultCode == -1) {
                        tv.setText((CharSequence)string2);
                        tv.setBackgroundColor(-16711936);
                        tv.setTextColor(-16777216);
                    } else {
                        tv.setText((CharSequence)("Roll failed " + resultCode + "\n" + string2));
                        tv.setBackgroundColor(-65536);
                        tv.setTextColor(-16777216);
                    }
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_devicesupport);
        this.activityContext = this;
        this.setTitle(" Devices");
        this.mReleaseService = 1;
        PclObject data = (PclObject)this.getLastNonConfigurationInstance();
        if (data == null || data.service == null || data.serviceConnection == null) {
            Log.d((String)"INGENICO", (String)"onCreate: Init service");
            this.initService();
        } else {
            Log.d((String)"INGENICO", (String)"onCreate: Service already initialized");
            this.mServiceConnection = data.serviceConnection;
            this.mPclService = data.service;
            this.mBound = true;
        }
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        Button cmdIngenicoStatus = (Button)this.findViewById(R.id.cmdIngenicoStatus);
        cmdIngenicoStatus.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new GetTermInfoTask().execute(new Void[0]);
            }
        });
        Button cmdScanPrinter = (Button)this.findViewById(R.id.cmdScanPrinter);
        cmdScanPrinter.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                byte[] result = new byte[1];
                TextView txtCCSTStatus = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Scanning barcode");
                new OpenBarcodeTask(result).execute(new Void[0]);
                Log.e((String)"INGENICO", (String)"Scan requested");
            }
        });
        Button cmdTestPrint = (Button)this.findViewById(R.id.cmdTestPrint);
        cmdTestPrint.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TextView txtCCSTStatus = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Test print requested");
                Log.e((String)"INGENICO", (String)"cmdTestPrint requested");
                FulfilmentManager.STDCreateCouponsResponse resp = FulfilmentManager.createTestCoupon();
                if (resp.ccstCoupons.size() < 1) {
                    txtCCSTStatus.setText((CharSequence)"Error formating test coupon ");
                    return;
                }
                CCSTCoupon coupon = resp.ccstCoupons.get(0);
                txtCCSTStatus.setText((CharSequence)"Printing test coupon ");
                Intent intent = new Intent((Context)DeviceSupport.this, CCSTPrinterService.class);
                intent.putExtra("message_request", 22);
                intent.putExtra("message_content", coupon.strPrintMessage);
                DeviceSupport.this.startService(intent);
            }
        });
        Button cmdConnRoll = (Button)this.findViewById(R.id.cmdConnRoll);
        cmdConnRoll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Log.e((String)"INGENICO", (String)"cmdConnRoll requested");
                TextView txtCCSTStatus = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Ready requested");
                Intent intent = new Intent((Context)DeviceSupport.this, RollPrinterService.class);
                intent.putExtra("message_request", 20);
                intent.putExtra("mac_address", "");
                DeviceSupport.this.startService(intent);
            }
        });
        Button cmdQueryRoll = (Button)this.findViewById(R.id.cmdQueryRoll);
        cmdQueryRoll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Log.e((String)"INGENICO", (String)"cmdQueryRoll requested");
                TextView txtCCSTStatus = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Ready requested");
                Intent intent = new Intent((Context)DeviceSupport.this, RollPrinterService.class);
                intent.putExtra("message_request", 22);
                intent.putExtra("message_content", "Test Print\n\n\n\n\n\n");
                DeviceSupport.this.startService(intent);
            }
        });
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        cmdDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Log.e((String)"INGENICO", (String)"cmdDone requested");
                Intent returnIntent = new Intent();
                DeviceSupport.this.setResult(-1, returnIntent);
                DeviceSupport.this.finish();
            }
        });
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Button cmdCCSTStatus = (Button)this.findViewById(R.id.cmdCCSTStatus);
        cmdCCSTStatus.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TextView txtCCSTStatus = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Checking printer");
                Intent intent = new Intent((Context)DeviceSupport.this, CCSTPrinterService.class);
                intent.putExtra("message_request", 21);
                intent.putExtra("mac_address", "");
                DeviceSupport.this.startService(intent);
            }
        });
        txtPED.setText((CharSequence)"Checking PED");
        this.CheckBluetooth();
    }

    @Override
    public void onStateChanged(String state) {
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        if (state.equals("CONNECTED")) {
            txtPED.setText((CharSequence)"Connected");
            txtPED.setBackgroundColor(-16711936);
            txtPED.setTextColor(-16777216);
            new GetTermInfoTask().execute(new Void[0]);
        } else {
            txtPED.setText((CharSequence)"Not connected");
            txtPED.setBackgroundColor(-65536);
            txtPED.setTextColor(-16777216);
        }
    }

    @Override
    public void onPclServiceConnected() {
        Log.d((String)"INGENICO", (String)"onPclServiceConnected");
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        if (this.isCompanionConnected()) {
            txtPED.setText((CharSequence)"Connected companion");
            txtPED.setBackgroundColor(-16711936);
            txtPED.setTextColor(-16777216);
            new GetTermInfoTask().execute(new Void[0]);
        } else {
            txtPED.setText((CharSequence)"Ped not connected");
            txtPED.setBackgroundColor(-65536);
            txtPED.setTextColor(-16777216);
        }
    }

    @Override
    public void onBarCodeReceived(String barCodeValue) {
        TextView txtCCSTPrinter = (TextView)this.findViewById(R.id.txtCCSTPrinter);
        txtCCSTPrinter.setText((CharSequence)barCodeValue);
        Log.d((String)"INGENICO", (String)"Begin DoResetCCSTTask");
        new DoResetCCSTTask(barCodeValue).execute(new Void[0]);
        Log.d((String)"INGENICO", (String)"End DoResetCCSTTask");
    }

    private boolean openBarcode(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.openBarcode(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        } else {
            Log.d((String)"INGENICO", (String)"openBarcode: mPclService is null");
        }
        return ret;
    }

    private boolean closeBarcode(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.closeBarcode(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public void CheckBluetooth() {
        if (this.bluetoothAdapter == null) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Oop! Your device does not support Bluetooth", (int)0).show();
        } else if (!this.bluetoothAdapter.isEnabled()) {
            Intent enableBluetoothIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableBluetoothIntent, 1);
        }
    }

    public void connectCCSTDevice(String macAddress) {
        Intent intent = new Intent((Context)this, CCSTPrinterService.class);
        intent.putExtra("message_request", 20);
        intent.putExtra("mac_address", macAddress);
        this.startService(intent);
    }

    public void closeCCSTDevice() {
        Intent intent = new Intent((Context)this, CCSTPrinterService.class);
        intent.putExtra("message_request", 23);
        intent.putExtra("mac_address", "");
        this.startService(intent);
    }

    public void connectRollDevice(String macAddress) {
        Intent intent = new Intent((Context)this, RollPrinterService.class);
        intent.putExtra("message_request", 20);
        intent.putExtra("mac_address", "");
        this.startService(intent);
    }

    public void closeRollDevice() {
        Intent intent = new Intent((Context)this, RollPrinterService.class);
        intent.putExtra("message_request", 23);
        intent.putExtra("mac_address", "");
        this.startService(intent);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode != -1) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Bluetooth is not enabled.", (int)0).show();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.registerReceiver(this.receiverCCST, new IntentFilter("com.example.twolibs"));
        this.registerReceiver(this.refreshScreen, new IntentFilter("com.example.twolibs"));
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.receiverCCST);
        this.unregisterReceiver(this.refreshScreen);
    }

    class DoResetCCSTTask
    extends AsyncTask<Void, Void, Boolean> {
        private String newMacAddress;

        public DoResetCCSTTask(String newMacAddress) {
            Log.d((String)"INGENICO", (String)String.format("DoResetCCSTTask CONSTRUCT", new Object[0]));
            this.newMacAddress = newMacAddress;
        }

        protected Boolean doInBackground(Void ... tmp) {
            boolean bRet = false;
            Log.d((String)"INGENICO", (String)"Close request");
            DeviceSupport.this.closeCCSTDevice();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Log.d((String)"INGENICO", (String)"Connect request");
            DeviceSupport.this.connectCCSTDevice("");
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)"INGENICO", (String)String.format("DoResetCCSTTask onPostExecute", new Object[0]));
            if (result.booleanValue()) {
                // empty if block
            }
        }
    }

    class DoResetRollTask
    extends AsyncTask<Void, Void, Boolean> {
        private String newMacAddress;

        public DoResetRollTask(String newMacAddress) {
            Log.d((String)"INGENICO", (String)String.format("DoResetCCSTTask CONSTRUCT", new Object[0]));
            this.newMacAddress = newMacAddress;
        }

        protected Boolean doInBackground(Void ... tmp) {
            boolean bRet = false;
            Log.d((String)"INGENICO", (String)"Close request");
            DeviceSupport.this.closeRollDevice();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Log.d((String)"INGENICO", (String)"Connect request");
            DeviceSupport.this.connectRollDevice("");
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)"INGENICO", (String)String.format("DoResetCCSTTask onPostExecute", new Object[0]));
            if (result.booleanValue()) {
                // empty if block
            }
        }
    }

    class DoTransactionTask
    extends AsyncTask<Void, Void, Boolean> {
        private TransactionIn transIn;
        private TransactionOut transOut;

        public DoTransactionTask(TransactionIn transIn, TransactionOut transOut) {
            Log.d((String)"INGENICO", (String)String.format("DoTransactionTask CONSTRUCT", new Object[0]));
            this.transIn = transIn;
            this.transOut = transOut;
        }

        protected Boolean doInBackground(Void ... tmp) {
            Boolean bRet = DeviceSupport.this.doTransaction(this.transIn, this.transOut);
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)"INGENICO", (String)String.format("DoTransactionTask onPostExecute", new Object[0]));
            if (this.transOut.getC3Error().equals("0000")) {
                AlertDialog.Builder alertbox = new AlertDialog.Builder(DeviceSupport.this.activityContext);
                alertbox.setMessage((CharSequence)DeviceSupport.this.getString(R.string.str_print));
                alertbox.setPositiveButton((CharSequence)DeviceSupport.this.getString(R.string.str_yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface arg0, int arg1) {
                    }
                });
                alertbox.setNegativeButton((CharSequence)DeviceSupport.this.getString(R.string.str_no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface arg0, int arg1) {
                        Toast.makeText((Context)DeviceSupport.this.getBaseContext(), (CharSequence)DeviceSupport.this.getString(R.string.str_thanks), (int)1).show();
                    }
                });
                alertbox.show();
            } else {
                Toast.makeText((Context)DeviceSupport.this.getBaseContext(), (CharSequence)DeviceSupport.this.getString(R.string.str_failed), (int)1).show();
            }
        }
    }

    class CloseBarcodeTask
    extends AsyncTask<Void, Void, Boolean> {
        private byte[] mResult;

        CloseBarcodeTask(byte[] result) {
            this.mResult = result;
        }

        protected Boolean doInBackground(Void ... dummy) {
            Boolean bRet = false;
            bRet = DeviceSupport.this.closeBarcode(this.mResult);
            Log.d((String)"INGENICO", (String)String.format("closeBarcode bRet=%s mResult=%d", Boolean.toString(bRet), this.mResult[0]));
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "N/A";
            TextView txtPED = (TextView)DeviceSupport.this.findViewById(R.id.txtPED);
            txtPED.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                switch (this.mResult[0]) {
                    case 0: {
                        strResult = "OK";
                        txtPED.setText((CharSequence)strResult);
                        break;
                    }
                    default: {
                        strResult = "Failed (" + this.mResult[0] + ")";
                        txtPED.setText((CharSequence)strResult);
                        break;
                    }
                }
            } else {
                txtPED.setText((CharSequence)"Failed ");
            }
        }
    }

    class OpenBarcodeTask
    extends AsyncTask<Void, Void, Boolean> {
        private byte[] mResult;

        OpenBarcodeTask(byte[] result) {
            this.mResult = result;
        }

        protected Boolean doInBackground(Void ... dummy) {
            Boolean bRet = false;
            bRet = DeviceSupport.this.openBarcode(this.mResult);
            Log.d((String)"INGENICO", (String)String.format("openBarcode bRet=%s mResult=%d", Boolean.toString(bRet), this.mResult[0]));
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "";
            TextView txtCCSTPrinter = (TextView)DeviceSupport.this.findViewById(R.id.txtCCSTPrinter);
            txtCCSTPrinter.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                switch (this.mResult[0]) {
                    case 0: {
                        strResult = "Barcode scanner ready";
                        break;
                    }
                    default: {
                        strResult = "Failed (" + this.mResult[0] + ")";
                        break;
                    }
                }
            } else {
                strResult = "Barcode scanner on";
            }
            txtCCSTPrinter.setText((CharSequence)strResult);
        }
    }

    class GetTermInfoTask
    extends AsyncTask<Void, Void, Boolean> {
        GetTermInfoTask() {
        }

        protected Boolean doInBackground(Void ... tmp) {
            Boolean bRet = DeviceSupport.this.getTermInfo();
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "PED not connected";
            TextView txtPED = (TextView)DeviceSupport.this.findViewById(R.id.txtPED);
            txtPED.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                strResult = String.format("SN: %08x PN:%08x", DeviceSupport.this.SN, DeviceSupport.this.PN);
                txtPED.setBackgroundColor(-16711936);
                txtPED.setTextColor(-16777216);
            } else {
                txtPED.setBackgroundColor(-65536);
                txtPED.setTextColor(-16777216);
            }
            txtPED.setText((CharSequence)strResult);
        }
    }

    static class PclObject {
        IngenicoCommon.PclServiceConnection serviceConnection;
        IPclService service;

        PclObject() {
        }
    }
}

