/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyBL;

import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.Duty;
import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.TimeTableBL.SearchResponse;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableBL.TTSearchCriteria;
import com.example.twolibs.TimeTableBL.TTStop;
import java.util.ArrayList;
import java.util.Date;

public class DutyManager
extends GenericManager {
    private static String CLASS_NAME = "DutyTaskType";
    private static boolean refreshRequired = true;
    private static String DataDomain = "DutyData";
    public static Duty activeDuty = null;
    public static DutyTask activeTask = null;

    public static void dataChanged(String pDataDomain) {
        if (pDataDomain.equals(DataDomain)) {
            refreshRequired = true;
        }
    }

    public static void refreshdata() {
        String FUNC_NAME = "refreshdata";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "refreshdata", TraceHandler.Category.ENTRY, "", 0);
        if (refreshRequired) {
            DutyTaskType.doLoadXML();
            Duty.doLoadXML();
            activeDuty = null;
            activeTask = null;
            refreshRequired = false;
        }
    }

    public static GenericManager.DomainStatusResponse checkStatus() {
        String FUNC_NAME = "checkStatus";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "checkStatus", TraceHandler.Category.ENTRY, "", 0);
        GenericManager.DomainStatusResponse resp = new GenericManager.DomainStatusResponse();
        DutyTask dueTask = null;
        if (activeDuty != null) {
            dueTask = activeDuty.updateTaskStates(DataConvert.getNow());
        }
        if (dueTask == null) {
            resp.status = GenericManager.MenuState.NORMAL;
            resp.shortDescrition = "Duty";
        } else {
            resp.status = GenericManager.MenuState.NOTIFY;
            resp.shortDescrition = "Duty\n(" + dueTask.taskType + ")";
        }
        return resp;
    }

    public static void setDuty(AppContext pAC, Duty pDuty) {
        String FUNC_NAME = "checkStatus";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "checkStatus", TraceHandler.Category.ENTRY, "", 0);
        activeDuty = pDuty;
        pDuty.updateTasktimes();
        for (DutyTask t : DutyManager.activeDuty.dutyActivities) {
            DutyTaskType dutyTaskType = DutyTaskType.getTaskType(t.taskType);
            if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.BOARD_TRAIN && t.trainRetailId.length() == 0) {
                TTSearchCriteria TTCrit = pAC.ttSearch.setupDefaults(t.taskLocationFrom, t.taskLocationTo, t.taskStart, 0, 0);
                TTCrit.setSc_earlierjourneys(0);
                TTCrit.setSc_laterjourneys(1);
                TTCrit.setSc_numovertaken(0);
                SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
                if (resp.objTTsearchResults.getSr_numjourneys() > 0) {
                    TTJourney jny = resp.objTTsearchResults.getSr_journeys().get(0);
                    DutyManager.setupJourneyDetails(jny, t);
                }
            }
            activeDuty.updateTaskStates(DataConvert.getNow());
        }
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "checkStatus", TraceHandler.Category.EXIT, "", 0);
    }

    public static void setTaskState(AppContext pAC, DutyTask pTask, DutyTask.TaskState pNewTaskState) {
        String FUNC_NAME = "setTaskState";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "setTaskState", TraceHandler.Category.ENTRY, pTask.taskId + " " + pNewTaskState.name(), 0);
        if (pTask.taskState == pNewTaskState) {
            TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "setTaskState", TraceHandler.Category.EXIT, "No change", 0);
            return;
        }
        DutyTaskType dutyTaskType = DutyTaskType.getTaskType(pTask.taskType);
        if (pNewTaskState == DutyTask.TaskState.ACTIVE && dutyTaskType.taskSpecialAction != DutyTaskType.TaskSpecialAction.NONE) {
            DutyManager.deactivateTasks();
            DutyTaskType taskType = DutyTaskType.getTaskType(pTask.taskType);
            if (taskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.BOARD_TRAIN) {
                TTSearchCriteria TTCrit = pAC.ttSearch.setupDefaults(pTask.taskLocationFrom, pTask.taskLocationTo, pTask.taskStart, 0, 0);
                TTCrit.setSc_earlierjourneys(0);
                TTCrit.setSc_laterjourneys(1);
                TTCrit.setSc_numovertaken(0);
                SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
                if (resp.objTTsearchResults.getSr_numjourneys() > 0) {
                    TTJourney jny = resp.objTTsearchResults.getSr_journeys().get(0);
                    DutyManager.setupJourneyDetails(jny, pTask);
                }
            }
        }
        pTask.taskState = pNewTaskState;
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "setTaskState", TraceHandler.Category.EXIT, "", 0);
    }

    public static void deactivateTasks() {
        String FUNC_NAME = "deactivateTasks";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "deactivateTasks", TraceHandler.Category.ENTRY, "", 0);
        if (activeDuty != null) {
            for (DutyTask task : DutyManager.activeDuty.dutyActivities) {
                DutyTaskType dutyTaskType = DutyTaskType.getTaskType(task.taskType);
                if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.NONE || task.taskState != DutyTask.TaskState.ACTIVE) continue;
                task.taskState = DutyTask.TaskState.COMPLETE;
            }
        }
    }

    public static void setupAdHocDuty(AppContext pAC, String pTaskType, Date pStartTime, Location pOrigin, Location pDestination, TTJourney pJny) {
        String FUNC_NAME = "setupAdHocDuty";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "setupAdHocDuty", TraceHandler.Category.ENTRY, pTaskType, 0);
        Duty adHoc = new Duty();
        adHoc.dutyId = "ADHOC";
        adHoc.dutyName = "Ad hoc duty";
        DutyTask task = new DutyTask();
        task.taskId = "1";
        task.taskType = pTaskType;
        DutyTaskType dutyTaskType = DutyTaskType.getTaskType(pTaskType);
        task.taskComment = dutyTaskType.taskTypeTitle;
        task.taskStart = pStartTime;
        task.taskState = DutyTask.TaskState.ACTIVE;
        task.taskLocationFrom = pOrigin;
        task.taskLocationTo = pDestination;
        adHoc.dutyActivities.add(task);
        adHoc.updateTasktimes();
        DutyManager.setDuty(pAC, adHoc);
        DutyManager.setTaskState(pAC, task, DutyTask.TaskState.ACTIVE);
    }

    public static void setupJourneyDetails(TTJourney pJny, DutyTask pTask) {
        String FUNC_NAME = "setupJourneyDetails";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "setupJourneyDetails", TraceHandler.Category.ENTRY, "", 0);
        TTLeg leg = pJny.getJy_legs().get(0);
        pTask.trainRetailId = leg.getLeg_retailTOC();
        pTask.trainHeadCode = "";
        pTask.trainDepart = leg.getLeg_departs();
        pTask.taskEnd = leg.getLeg_arrives();
        pTask.reservations = leg.getLeg_reservable() != 4;
        pTask.trainStopsNLC = pJny.getStopsNLC(pJny);
    }

    public static void doGetRelatedEvents(AppContext pAC, Date pTime) {
        String FUNC_NAME = "doGetRelatedEvents";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doGetRelatedEvents", TraceHandler.Category.ENTRY, "", 0);
        if (activeDuty == null) {
            return;
        }
        ArrayList<DutyTask> listAssistPass = new ArrayList<DutyTask>();
        for (DutyTask t : DutyManager.activeDuty.dutyActivities) {
            TTJourney jny;
            TTLeg leg;
            if (!t.taskType.equals("AP")) {
                listAssistPass.add(t);
            }
            if (t.taskState.ordinal() < DutyTask.TaskState.COMPLETE.ordinal() && t.assistedPassengers) {
                t.assistPassChecked = DataConvert.getNow();
            }
            DutyTaskType dutyTaskType = DutyTaskType.getTaskType(t.taskType);
            if (t.taskState.ordinal() >= DutyTask.TaskState.COMPLETE.ordinal() || dutyTaskType.taskSpecialAction != DutyTaskType.TaskSpecialAction.BOARD_TRAIN) continue;
            TTSearchCriteria TTCrit = pAC.ttSearch.setupDefaults(t.taskLocationFrom, t.taskLocationTo, t.taskStart, 0, 0);
            TTCrit.setSc_earlierjourneys(0);
            TTCrit.setSc_laterjourneys(1);
            TTCrit.setSc_numovertaken(0);
            SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
            if (resp.objTTsearchResults.getSr_numjourneys() <= 0 || (leg = (jny = resp.objTTsearchResults.getSr_journeys().get(0)).getJy_legs().get(0)).getPassstops().size() <= 1) continue;
            TTStop stop = leg.getPassstops().get(0);
            DutyTask taskAssist = new DutyTask();
            taskAssist.taskId = t.taskId + "-1";
            taskAssist.taskType = "AP";
            taskAssist.taskState = DutyTask.TaskState.TODO;
            taskAssist.taskEnd = taskAssist.taskStart = DataConvert.setTime(null, DataConvert.stringToInt(stop.getPse_arrives().substring(0, 2)), DataConvert.stringToInt(stop.getPse_arrives().substring(2, 4)), 0);
            taskAssist.taskLocationFrom = Location.getLocationByCRS(stop.getPse_station());
            taskAssist.taskComment = "Passenger boarding";
            listAssistPass.add(taskAssist);
            stop = leg.getPassstops().get(1);
            taskAssist = new DutyTask();
            taskAssist.taskId = t.taskId + "-2";
            taskAssist.taskType = "AP";
            taskAssist.taskState = DutyTask.TaskState.TODO;
            taskAssist.taskEnd = taskAssist.taskStart = DataConvert.setTime(null, DataConvert.stringToInt(stop.getPse_arrives().substring(0, 2)), DataConvert.stringToInt(stop.getPse_arrives().substring(2, 4)), 0);
            taskAssist.taskLocationFrom = Location.getLocationByCRS(stop.getPse_station());
            taskAssist.taskComment = "Passenger alighting";
            listAssistPass.add(taskAssist);
        }
        DutyManager.activeDuty.dutyActivities = listAssistPass;
        activeDuty.updateTaskStates(pTime);
    }

    public static ArrayList<Duty> doSearchDuty(String pSearch) {
        String FUNC_NAME = "doSearchDuty";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearchDuty", TraceHandler.Category.ENTRY, pSearch, 0);
        ArrayList<Duty> myList = new ArrayList<Duty>();
        for (Duty duty : Duty.allDutys) {
            if (DataConvert.toUpperCase(duty.dutyId).startsWith(pSearch)) {
                myList.add(duty);
                continue;
            }
            if (!DataConvert.toUpperCase(duty.dutyName).contains(pSearch)) continue;
            myList.add(duty);
        }
        return myList;
    }

    public static ArrayList<DutyTaskType> doSearchTask(String pSearch) {
        String FUNC_NAME = "doSearchTask";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearchTask", TraceHandler.Category.ENTRY, pSearch, 0);
        ArrayList<DutyTaskType> myList = new ArrayList<DutyTaskType>();
        for (DutyTaskType dutyTaskType : DutyTaskType.dutyTaskTypes.values()) {
            if (DataConvert.toUpperCase(dutyTaskType.taskTypeCode).startsWith(pSearch)) {
                myList.add(dutyTaskType);
                continue;
            }
            if (!DataConvert.toUpperCase(dutyTaskType.taskTypeTitle).contains(pSearch)) continue;
            myList.add(dutyTaskType);
        }
        return myList;
    }
}

