/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;

public class DutyTaskListAdaptor
extends ArrayAdapter<DutyTask> {
    private static String CLASS_NAME = "DutyTaskListAdaptor";
    private final Activity context;
    private final AppContext bb;
    private final ArrayList<DutyTask> dutyTaskList;
    private View.OnClickListener mOnTaskStateClickListener = new View.OnClickListener(){

        public void onClick(View pView) {
            RelativeLayout row_container = (RelativeLayout)pView.getParent();
            ListView parent = (ListView)row_container.getParent();
            int position = parent.getPositionForView(pView);
            final DutyTask task = (DutyTask)DutyTaskListAdaptor.this.dutyTaskList.get(position);
            if (position != -1) {
                AlertDialog.Builder listBuilder = new AlertDialog.Builder((Context)DutyTaskListAdaptor.this.context);
                listBuilder.setTitle((CharSequence)"Task state");
                listBuilder.setItems((CharSequence[])DutyTask.TaskState.names, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int item) {
                        String FUNC_NAME = "onClick";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onClick", TraceHandler.Category.GUI, "list " + DutyTask.TaskState.values()[item].name(), 0);
                        DutyManager.setTaskState(DutyTaskListAdaptor.this.bb, task, DutyTask.TaskState.values()[item]);
                        DutyTaskListAdaptor.this.notifyDataSetChanged();
                    }
                });
                AlertDialog alertList = listBuilder.create();
                alertList.show();
            }
        }
    };

    public DutyTaskListAdaptor(Activity pContext, ArrayList<DutyTask> pDutyTaskList, AppContext pBB) {
        super((Context)pContext, R.layout.dutytask_entry, pDutyTaskList);
        this.context = pContext;
        this.bb = pBB;
        this.dutyTaskList = pDutyTaskList;
    }

    public View getView(int pPosition, View pRowView, ViewGroup pParent) {
        View rowView = pRowView;
        LayoutInflater inflater = this.context.getLayoutInflater();
        if (rowView == null) {
            rowView = inflater.inflate(R.layout.dutytask_entry, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.lay_entry = (LinearLayout)rowView.findViewById(R.id.lay_entry);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        rowView.setBackgroundColor(0);
        DutyTask d = this.dutyTaskList.get(pPosition);
        DutyTaskType dtt = DutyTaskType.getTaskType(d.taskType);
        holder.lay_entry.removeAllViews();
        if (dtt.taskSpecialAction == DutyTaskType.TaskSpecialAction.BOARD_TRAIN) {
            this.displayTrain(holder, inflater, rowView, d);
        } else {
            this.displayStatic(holder, inflater, rowView, d);
        }
        holder.lay_entry.setOnClickListener(this.mOnTaskStateClickListener);
        TextView txtDutyState = (TextView)rowView.findViewById(R.id.txtDutyState);
        if (d.taskSelected) {
            txtDutyState.setEnabled(true);
            txtDutyState.setTextColor(this.JMgetColor(R.color.button_text, this.context.getTheme()));
            txtDutyState.setBackgroundColor(this.JMgetColor(R.color.button_background, this.context.getTheme()));
        } else {
            txtDutyState.setEnabled(false);
            txtDutyState.setTextColor(this.JMgetColor(R.color.edit_text, this.context.getTheme()));
            txtDutyState.setBackgroundColor(0);
        }
        return rowView;
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.context.getResources().getColor(Color, TH);
        }
        return this.context.getResources().getColor(Color);
    }

    private void displayStatic(ViewHolder pHolder, LayoutInflater pInflater, View pRowView, DutyTask pTask) {
        pHolder.lay_entry.addView(pInflater.inflate(R.layout.duty_static_entry, null));
        TextView txtStartTime = (TextView)pRowView.findViewById(R.id.txtStartTime);
        TextView txtComment = (TextView)pRowView.findViewById(R.id.txtComment);
        TextView txtCRS = (TextView)pRowView.findViewById(R.id.txtCRS);
        TextView txtLocation = (TextView)pRowView.findViewById(R.id.txtLocation);
        TextView txtDutyState = (TextView)pRowView.findViewById(R.id.txtDutyState);
        txtStartTime.setText((CharSequence)DataConvert.displayTextTime(pTask.taskStart));
        txtComment.setText((CharSequence)pTask.taskComment);
        txtCRS.setText((CharSequence)pTask.taskLocationFrom.getCRS());
        txtLocation.setText((CharSequence)pTask.taskLocationFrom.getDescription());
        txtDutyState.setText((CharSequence)pTask.taskStateDesc());
        if (pTask.taskState == DutyTask.TaskState.DUE) {
            pHolder.lay_entry.setBackgroundColor(this.JMgetColor(R.color.icon_background_active, this.context.getTheme()));
        } else if (pTask.taskState == DutyTask.TaskState.ACTIVE) {
            pHolder.lay_entry.setBackgroundColor(this.JMgetColor(R.color.icon_background_good, this.context.getTheme()));
        } else {
            pHolder.lay_entry.setBackgroundColor(0);
        }
    }

    private void displayTrain(ViewHolder pHolder, LayoutInflater pInflater, View pRowView, DutyTask pTask) {
        pHolder.lay_entry.addView(pInflater.inflate(R.layout.duty_train_entry, null));
        TextView txtStartTime = (TextView)pRowView.findViewById(R.id.txtStartTime);
        TextView txtComment = (TextView)pRowView.findViewById(R.id.txtComment);
        TextView txtFromCRS = (TextView)pRowView.findViewById(R.id.txtFromCRS);
        TextView txtFromLocation = (TextView)pRowView.findViewById(R.id.txtFromLocation);
        TextView txtToCRS = (TextView)pRowView.findViewById(R.id.txtToCRS);
        TextView txtToLocation = (TextView)pRowView.findViewById(R.id.txtToLocation);
        TextView txtTrainID = (TextView)pRowView.findViewById(R.id.txtTrainID);
        TextView txtDeptTime = (TextView)pRowView.findViewById(R.id.txtDeptTime);
        TextView txtReservations = (TextView)pRowView.findViewById(R.id.txtReservations);
        TextView txtReservationsChecked = (TextView)pRowView.findViewById(R.id.txtReservationsChecked);
        TextView txtAssistPass = (TextView)pRowView.findViewById(R.id.txtAssistPass);
        TextView txtAssistPassChecked = (TextView)pRowView.findViewById(R.id.txtAssistPassChecked);
        TextView txtDutyState = (TextView)pRowView.findViewById(R.id.txtDutyState);
        txtStartTime.setText((CharSequence)DataConvert.displayTextTime(pTask.taskStart));
        txtComment.setText((CharSequence)pTask.taskComment);
        txtDeptTime.setText((CharSequence)("(" + DataConvert.displayTextTime(pTask.trainDepart) + " " + pTask.trainHeadCode + ")"));
        txtFromCRS.setText((CharSequence)pTask.taskLocationFrom.getCRS());
        txtFromLocation.setText((CharSequence)pTask.taskLocationFrom.getDescription());
        txtToCRS.setText((CharSequence)pTask.taskLocationTo.getCRS());
        txtToLocation.setText((CharSequence)pTask.taskLocationTo.getDescription());
        txtTrainID.setText((CharSequence)(pTask.trainRetailId + " to "));
        if (pTask.reservations) {
            txtReservations.setText((CharSequence)"Reservations");
        } else {
            txtReservations.setText((CharSequence)"Not reservable");
        }
        if (pTask.assistedPassengers) {
            txtAssistPass.setText((CharSequence)"Check Assisted Passengers");
        } else {
            txtAssistPass.setText((CharSequence)"");
        }
        if (pTask.assistPassChecked != null) {
            txtAssistPass.setText((CharSequence)"Assist Pass checked");
            txtAssistPassChecked.setText((CharSequence)DataConvert.displayTextTime(pTask.assistPassChecked));
        } else {
            txtAssistPassChecked.setText((CharSequence)"");
        }
        txtDutyState.setText((CharSequence)pTask.taskStateDesc());
        if (pTask.taskState == DutyTask.TaskState.DUE) {
            pHolder.lay_entry.setBackgroundColor(this.JMgetColor(R.color.icon_background_active, this.context.getTheme()));
        } else if (pTask.taskState == DutyTask.TaskState.ACTIVE) {
            pHolder.lay_entry.setBackgroundColor(this.JMgetColor(R.color.icon_background_good, this.context.getTheme()));
        } else {
            pHolder.lay_entry.setBackgroundColor(0);
        }
    }

    static class ViewHolder {
        public LinearLayout lay_entry;

        ViewHolder() {
        }
    }
}

