/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresBL;

import android.os.Environment;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.FareSet;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.SupportBL.DataConvert;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FareSetManager {
    public FareSet favouriteFareSet = null;
    public FareSet instantFareSet = null;
    public ArrayList<FareSet> favouriteFares = new ArrayList();
    public ArrayList<FareSet> instantFares = new ArrayList();

    public STDResponse doLoad(AppContext bb) {
        STDResponse resp = new STDResponse();
        resp.result = -1;
        resp.trace = "Begin";
        this.favouriteFares = FareSetManager.doLoadFavouritesXML();
        this.instantFares = FareSetManager.doLoadInstantXML();
        resp.trace = "Loaded";
        return resp;
    }

    public static ArrayList<FareSet> doLoadFavouritesXML() {
        String locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/favourite_fareset.xml";
        return FareSetManager.doLoadFareSetXML(locfile);
    }

    public static ArrayList<FareSet> doLoadInstantXML() {
        String locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/instant_fareset.xml";
        return FareSetManager.doLoadFareSetXML(locfile);
    }

    private static ArrayList<FareSet> doLoadFareSetXML(String locfile) {
        ArrayList<FareSet> allFareSets = new ArrayList<FareSet>();
        File file = new File(locfile);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("fareSet");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                FareSet fareSet = FareSet.fromXML(node);
                allFareSets.add(fareSet);
            }
        }
        catch (Exception e) {
            System.out.println("XML Pasing Excpetion = " + e);
        }
        return allFareSets;
    }

    public static ArrayList<FareSet> doSearchFareSet(String sSearch, ArrayList<FareSet> allFareSets) {
        ArrayList<FareSet> myList = new ArrayList<FareSet>();
        for (FareSet fareSet : allFareSets) {
            if (fareSet.faresetId.toUpperCase().startsWith(sSearch)) {
                myList.add(fareSet);
                continue;
            }
            if (!fareSet.faresetName.toUpperCase().contains(sSearch)) continue;
            myList.add(fareSet);
        }
        return myList;
    }

    public void setFavouriteFareSet(AppContext bb, String fareSetID) {
        this.favouriteFareSet = FareSetManager.lookupFareSet(fareSetID, this.favouriteFares);
        if (this.favouriteFareSet == null) {
            return;
        }
        this.setupPresetFares(bb, this.favouriteFareSet);
    }

    public void setInstantFareSet(AppContext bb, String fareSetID) {
        this.instantFareSet = FareSetManager.lookupFareSet(fareSetID, this.instantFares);
        if (this.instantFareSet == null) {
            return;
        }
        this.setupPresetFares(bb, this.instantFareSet);
    }

    public static FareSet lookupFareSet(String fareSetID, ArrayList<FareSet> allFareSets) {
        for (FareSet fareSet : allFareSets) {
            if (!fareSet.faresetId.equals(fareSetID)) continue;
            return fareSet;
        }
        return null;
    }

    public void setupPresetFares(AppContext bb, FareSet fareSet) {
        for (TNSearchCriteria fareCriteria : fareSet.fareSearches) {
            fareCriteria.CurrentDateTime = DataConvert.getNow();
            fareCriteria.OutDateTime = DataConvert.getNow();
            FareManager.SearchResponse resp = bb.fareManager.doSearch(fareCriteria, 3, true);
            if (resp.fares.size() <= 0) continue;
            fareCriteria.PresetFare = resp.fares.get(0);
        }
    }

    public ArrayList<TNFare> getPresetFares(AppContext bb, FareSet fareSet) {
        ArrayList<TNFare> fares = new ArrayList<TNFare>();
        if (fareSet != null) {
            for (TNSearchCriteria fareCriteria : fareSet.fareSearches) {
                if (fareCriteria.PresetFare == null) continue;
                fares.add(fareCriteria.PresetFare);
            }
        }
        return fares;
    }

    public void addFareToSet(FareSet fareSet, TNFare fare) {
        TNSearchCriteria fareCriteria = new TNSearchCriteria();
        fareCriteria.OriginUIC = fare.getFa_FareOriginLocation();
        fareCriteria.DestinationUIC = fare.getFa_FareOriginLocation();
        fareCriteria.OutDateTime = null;
        fareCriteria.ReturnDateTime = null;
        fareCriteria.CurrentDateTime = null;
        fareCriteria.NumAdults = fare.getFa_NumAdults();
        fareCriteria.NumChildren = fare.getFa_NumChildren();
        fareCriteria.NumAAA = fare.getFa_NumAAA();
        fareCriteria.RailcardCode = fare.getFa_RailcardCode();
        fareCriteria.TicketCode = fare.getFa_TicketTypeCode();
        fareCriteria.RouteCode = fare.getFa_RouteCode();
        fareCriteria.Sequence = 0;
        fareCriteria.PresetFare = fare;
        fareSet.fareSearches.add(fareCriteria);
        int i = 0;
        for (TNSearchCriteria fc : fareSet.fareSearches) {
            fc.PresetFare.itemSelected = 0;
            fc.Sequence = i++;
        }
    }

    public class STDResponse {
        public int result = 0;
        public String extra = "";
        public String trace = "";
    }
}

