/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresGUI;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.FaresBL.TNSearchResults;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.FaresGUI.TicketListAdaptor;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SupportBL.DataConvert;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FaresLookup
extends ListActivity {
    int iCurrentMenu = -1;
    int iCurrentSelection = -1;
    ArrayList<TNFare> list = new ArrayList();
    TicketListAdaptor adapter;
    ListView listview;
    int iNumRequested = 10;
    Context context = null;
    String nextAction = "";

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_fareslookup);
        this.context = this;
        Intent intent = this.getIntent();
        if (intent != null) {
            this.nextAction = intent.getStringExtra("nextAction");
            if (this.nextAction != null) {
                if (this.nextAction.equals("search")) {
                    this.setTitle(" Anywhere to Anywhere");
                } else if (this.nextAction.equals("historic")) {
                    this.setTitle(" Repeat Fares");
                } else if (this.nextAction.equals("instant")) {
                    this.setTitle(" Instant Fare");
                } else if (this.nextAction.equals("favourite")) {
                    this.setTitle(" Favourite Fare");
                } else if (this.nextAction.equals("addToFareSet")) {
                    this.setTitle(" Add Fare");
                } else {
                    this.setTitle(" Fares");
                }
            } else {
                this.nextAction = "";
            }
        }
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.doLoad(bb);
        this.listview = (ListView)this.findViewById(16908298);
        this.adapter = new TicketListAdaptor((Activity)this, this.list, bb);
        this.setListAdapter((ListAdapter)this.adapter);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    View rowView = parent.getChildAt(j);
                    rowView.setBackgroundColor(0);
                    TextView txtFulfillmentType = (TextView)rowView.findViewById(R.id.txtFulfillmentType);
                    txtFulfillmentType.setTextColor(FaresLookup.this.JMgetColor(R.color.edit_text, FaresLookup.this.getTheme()));
                    txtFulfillmentType.setBackgroundColor(0);
                    TNFare fare = FaresLookup.this.list.get(j);
                    txtFulfillmentType.setText((CharSequence)fare.getFa_FulfillmentMethod());
                }
                if (position == FaresLookup.this.iCurrentSelection) {
                    if (FaresLookup.this.nextAction.equals("addToFareSet")) {
                        FaresLookup.this.setMenu(2);
                    } else {
                        FaresLookup.this.setMenu(0);
                    }
                    bb.selFare = null;
                    FaresLookup.this.iCurrentSelection = -1;
                    FaresLookup.this.list.get((int)position).itemSelected = 0;
                } else {
                    if (FaresLookup.this.nextAction.equals("addToFareSet")) {
                        FaresLookup.this.setMenu(2);
                    } else {
                        FaresLookup.this.setMenu(1);
                    }
                    bb.selFare = FaresLookup.this.list.get(position);
                    FaresLookup.this.iCurrentSelection = position;
                    FaresLookup.this.list.get((int)position).itemSelected = 1;
                    view.setBackgroundColor(FaresLookup.this.JMgetColor(R.color.selection_background, FaresLookup.this.getTheme()));
                    TextView txtFulfillmentType = (TextView)view.findViewById(R.id.txtFulfillmentType);
                    txtFulfillmentType.setTextColor(FaresLookup.this.JMgetColor(R.color.button_text, FaresLookup.this.getTheme()));
                    txtFulfillmentType.setBackgroundColor(FaresLookup.this.JMgetColor(R.color.button_background, FaresLookup.this.getTheme()));
                }
            }
        });
        this.iNumRequested = 10;
        if (this.nextAction.equals("search")) {
            this.doSearch();
        } else if (this.nextAction.equals("historic")) {
            this.doHistory();
        } else if (this.nextAction.equals("instant")) {
            this.doInstant();
        } else if (this.nextAction.equals("favourite")) {
            this.doFavourite();
        } else if (this.nextAction.equals("addToFareSet")) {
            this.doSearch();
        } else {
            this.setTitle(" Fares");
        }
        if (this.nextAction.equals("addToFareSet")) {
            this.setMenu(2);
        } else {
            this.setMenu(0);
        }
    }

    public void doLoad(AppContext bb) {
        String fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FARES.FIB";
        FareManager.STDResponse resp = bb.fareManager.doLoad(fibFile);
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        tv.setText((CharSequence)(resp.extra + resp.trace));
    }

    public void doSearch() {
        String sProgress = "";
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        AppContext bb = (AppContext)this.getApplicationContext();
        TNSearchCriteria TNCrit = new TNSearchCriteria();
        Location objOrigin = bb.getOrigin();
        Location objDestination = bb.getDestination();
        if (objOrigin.getNLC().equals("")) {
            tv.setText((CharSequence)"No origin specified");
            return;
        }
        TNCrit.OriginUIC = objOrigin.getUIC();
        if (objDestination.getNLC().equals("")) {
            tv.setText((CharSequence)"No destination specified");
            return;
        }
        TNCrit.DestinationUIC = objDestination.getUIC();
        TNCrit.OutDateTime = bb.getSearchDate();
        TNCrit.ReturnDateTime = null;
        TNCrit.CurrentDateTime = bb.getSearchDate();
        TNCrit.NumAdults = bb.getNumAdults();
        TNCrit.NumChildren = bb.getNumChildren();
        TNCrit.NumAAA = bb.getNumAAA();
        TNCrit.RailcardCode = bb.getRailcardCode();
        TNCrit.VariableDiscount = bb.getVariableDiscount();
        TNCrit.UseFutureFares = false;
        TNCrit.TicketCode = "";
        TNCrit.RouteCode = "";
        String outDate = DataConvert.displayyyyyMMddHHmm(TNCrit.OutDateTime);
        if (TNCrit.ReturnDateTime == null) {
            String retDate = "000000000000";
        } else {
            String retDate = DataConvert.displayyyyyMMddHHmm(TNCrit.ReturnDateTime);
        }
        String TicketCode = "";
        String RouteCode = "";
        TNSearchResults objTNSearchResults = new TNSearchResults();
        String fileName = Environment.getExternalStorageDirectory() + "/com.example.twolibs/Fare-" + TNCrit.OriginUIC + "-" + TNCrit.DestinationUIC + ".txt";
        File file = new File(fileName);
        FareManager.SearchResponse result = bb.fareManager.doSearch(TNCrit, bb.faresClass, bb.getShowAllFares());
        if (bb.faresSortType == 0) {
            if (bb.faresSortOrder == 0) {
                Collections.sort(result.fares, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        TNFare p1 = (TNFare)o1;
                        TNFare p2 = (TNFare)o2;
                        return p1.getFa_TotalFareS() - p2.getFa_TotalFareS();
                    }
                });
            } else {
                Collections.sort(result.fares, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        TNFare p1 = (TNFare)o1;
                        TNFare p2 = (TNFare)o2;
                        return p2.getFa_TotalFareS() - p1.getFa_TotalFareS();
                    }
                });
            }
        } else if (bb.faresSortOrder == 0) {
            Collections.sort(result.fares, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TNFare p1 = (TNFare)o1;
                    TNFare p2 = (TNFare)o2;
                    return p1.getFa_PublicationSequence().compareToIgnoreCase(p2.getFa_PublicationSequence());
                }
            });
        } else {
            Collections.sort(result.fares, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TNFare p1 = (TNFare)o1;
                    TNFare p2 = (TNFare)o2;
                    return p2.getFa_PublicationSequence().compareToIgnoreCase(p1.getFa_PublicationSequence());
                }
            });
        }
        sProgress = sProgress + "Found " + result.fares.size();
        tv.setText((CharSequence)sProgress);
        this.adapter.clear();
        this.adapter.addAll(result.fares);
        this.adapter.notifyDataSetChanged();
    }

    public void doHistory() {
        String sProgress = "";
        AppContext bb = (AppContext)this.getApplicationContext();
        sProgress = sProgress + "Found " + bb.fareManager.historicFares.size();
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        tv.setText((CharSequence)sProgress);
        for (TNFare fare : bb.fareManager.historicFares) {
            fare.itemSelected = 0;
        }
        this.adapter.clear();
        this.adapter.addAll(bb.fareManager.historicFares);
        this.adapter.notifyDataSetChanged();
    }

    public void doInstant() {
        String sProgress = "";
        AppContext bb = (AppContext)this.getApplicationContext();
        ArrayList<Object> fares = new ArrayList();
        if (bb.fareSetManager.instantFareSet == null) {
            sProgress = "No instant fares set";
        } else {
            fares = bb.fareSetManager.getPresetFares(bb, bb.fareSetManager.instantFareSet);
            if (fares.size() > 0) {
                sProgress = sProgress + "Found " + fares.size();
                for (TNFare tNFare : fares) {
                    tNFare.itemSelected = 0;
                }
            } else {
                sProgress = "No fares setup";
            }
        }
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        tv.setText((CharSequence)sProgress);
        this.adapter.clear();
        this.adapter.addAll(fares);
        this.adapter.notifyDataSetChanged();
    }

    public void doFavourite() {
        String sProgress = "";
        AppContext bb = (AppContext)this.getApplicationContext();
        ArrayList<Object> fares = new ArrayList();
        if (bb.fareSetManager.favouriteFareSet == null) {
            sProgress = "No favourite fares set";
        } else {
            fares = bb.fareSetManager.getPresetFares(bb, bb.fareSetManager.favouriteFareSet);
            if (fares.size() > 0) {
                sProgress = sProgress + "Found " + fares.size();
                for (TNFare tNFare : fares) {
                    tNFare.itemSelected = 0;
                }
            } else {
                sProgress = "No fares setup";
            }
        }
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        tv.setText((CharSequence)sProgress);
        this.adapter.clear();
        this.adapter.addAll(fares);
        this.adapter.notifyDataSetChanged();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public Intent getParentActivityIntent() {
        Intent newIntent = new Intent(this.getApplicationContext(), FaresCriteria.class);
        return newIntent;
    }

    private void setMenu(int iMenu) {
        if (iMenu != this.iCurrentMenu) {
            LinearLayout layFormMenu = (LinearLayout)this.findViewById(R.id.layFormMenu);
            layFormMenu.removeAllViews();
            LayoutInflater inflater = this.getLayoutInflater();
            if (iMenu == 0) {
                layFormMenu.addView(inflater.inflate(R.layout.fareslookup_menu0, null));
                Button cmdEarlier = (Button)this.findViewById(R.id.cmdBasket);
                cmdEarlier.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "basket");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
                Button cmdOrder = (Button)this.findViewById(R.id.cmdOrder);
                cmdOrder.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)FaresLookup.this, (CharSequence)"Order  Clicked", (int)0).show();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
            } else if (iMenu == 1) {
                layFormMenu.addView(inflater.inflate(R.layout.fareslookup_menu1, null));
                Button cmdEarlier = (Button)this.findViewById(R.id.cmdBasket);
                cmdEarlier.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)FaresLookup.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selFare != null) {
                            TNFare tt = bb.selFare;
                            bs.addTicket(tt, tt.getFa_TotalFareS());
                        }
                        Toast.makeText((Context)FaresLookup.this, (CharSequence)("Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
                Button cmdLater = (Button)this.findViewById(R.id.cmdCard);
                cmdLater.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)FaresLookup.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selFare != null) {
                            TNFare tt = bb.selFare;
                            bs.addTicket(tt, tt.getFa_TotalFareS());
                        }
                        Toast.makeText((Context)FaresLookup.this, (CharSequence)("Card  Clicked - Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "card");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
                Button cmdCash = (Button)this.findViewById(R.id.cmdCash);
                cmdCash.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)FaresLookup.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selFare != null) {
                            TNFare tt = bb.selFare;
                            bs.addTicket(tt, tt.getFa_TotalFareS());
                        }
                        Toast.makeText((Context)FaresLookup.this, (CharSequence)("Cash  Clicked - Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "cash");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
            } else {
                layFormMenu.addView(inflater.inflate(R.layout.fareslookup_menu2, null));
                Button cmdAdd = (Button)this.findViewById(R.id.cmdAdd);
                cmdAdd.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)FaresLookup.this.getApplicationContext();
                        bb.selFare = null;
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        FaresLookup.this.setResult(-1, returnIntent);
                        FaresLookup.this.finish();
                    }
                });
            }
            this.iCurrentMenu = iMenu;
        }
    }
}

