/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.LocationBL;

import com.example.twolibs.LocationBL.LocationManager;
import java.io.Serializable;
import java.util.HashMap;

public class Location
implements Serializable {
    static HashMap<String, Location> crsCodes = new HashMap();
    static HashMap<String, Location> nlcCodes = new HashMap();
    static LocationManager locSearch = new LocationManager();
    String strNLC = "";
    String strCRS = "";
    String strSize = "";
    String strDescription = "";

    public String getNLC() {
        return this.strNLC;
    }

    public void setNLC(String p) {
        this.strNLC = p;
    }

    public String getUIC() {
        if (this.strNLC.length() == 4) {
            return "70" + this.strNLC + "0";
        }
        if (this.strNLC.length() == 6) {
            return this.strNLC + "0";
        }
        return this.strNLC;
    }

    public String getCRS() {
        return this.strCRS;
    }

    public void setCRS(String p) {
        this.strCRS = p;
    }

    public String getSize() {
        return this.strSize;
    }

    public void setSize(String p) {
        this.strSize = p;
    }

    public String getDescription() {
        return this.strDescription;
    }

    public void setDescription(String p) {
        this.strDescription = p;
    }

    public void setBaseString(String p) {
        String delims = "[|]";
        String[] tokens = p.split(delims);
        this.strNLC = tokens[0];
        this.strCRS = tokens[1];
        this.strSize = tokens[2];
        this.strDescription = tokens[3];
    }

    public static Location getLocationByCRS(String crsCode) {
        Location loc;
        if (crsCodes.containsKey(crsCode)) {
            loc = crsCodes.get(crsCode);
        } else {
            LocationManager.LookupResponse resp = locSearch.GetLocationByCRS(crsCode);
            if (resp.result == 0) {
                loc = resp.location;
                crsCodes.put(crsCode, loc);
            } else {
                loc = null;
            }
        }
        return loc;
    }

    public static Location getLocationByNLC(String nlcCode) {
        Location loc;
        if (nlcCodes.containsKey(nlcCode)) {
            loc = nlcCodes.get(nlcCode);
        } else {
            LocationManager.LookupResponse resp = locSearch.GetLocationByNLC(nlcCode);
            if (resp.result == 0) {
                loc = resp.location;
                nlcCodes.put(nlcCode, loc);
            } else {
                loc = null;
            }
        }
        return loc;
    }
}

