/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.LocationBL;

import com.example.twolibs.LocationBL.clsIJQLocation;
import com.example.twolibs.LocationBL.clsLocationLink;
import com.example.twolibs.LocationBL.clsPTEZones;
import com.example.twolibs.LocationBL.clsZone;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class clsLocation
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1352874795293552470L;
    public String UIC7;
    public String NLCCode;
    public Vector<clsLocationLink> locationLinks;
    public String specialFacilities;
    public Vector<String> railcards;
    public String CRSCode;
    public String groupCode;
    public String countyCode;
    public String zoneCode;
    public String zoneInd;
    public String PTECode;
    public Date startDate;
    public Date endDate = new Date();
    public String description;
    public boolean isAnENRGStation;
    public Vector<clsZone> fareZones;
    public Vector<clsZone> PTEZones;
    public clsIJQLocation THOLocation;
    public String boundaryZoneNo;
    public String hierarchy;

    public clsLocation() {
        this.startDate = new Date();
        this.locationLinks = new Vector();
        this.railcards = new Vector();
        this.fareZones = new Vector();
        this.PTEZones = new Vector();
    }

    public boolean isMemberOfAFaresGroup() {
        return this.groupCode != null && !this.groupCode.equals(this.NLCCode);
    }

    public boolean isAFaresGroup() {
        boolean ret = false;
        if (this.locationLinks != null) {
            for (clsLocationLink locLink : this.locationLinks) {
                if (locLink.type != 2) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean isATTGroup() {
        boolean ret = false;
        if (this.locationLinks != null) {
            for (clsLocationLink locLink : this.locationLinks) {
                if (locLink.type != 1) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String deriveCountryCode() {
        String countryCode = " ";
        try {
            int countyNumber = Integer.valueOf(this.countyCode);
            countryCode = countyNumber >= 38 && countyNumber <= 43 ? "S" : "E";
        }
        catch (NumberFormatException ex) {
            countryCode = " ";
        }
        return countryCode;
    }

    public Vector<clsLocationLink> getLocationLinksForType(int type, int qualifier) {
        Vector<clsLocationLink> locLinks = new Vector<clsLocationLink>();
        if (this.locationLinks != null) {
            for (clsLocationLink locLink : this.locationLinks) {
                if (locLink.type != type) continue;
                if (qualifier == -1) {
                    locLinks.add(locLink);
                    continue;
                }
                if (locLink.qualifier != qualifier) continue;
                locLinks.add(locLink);
            }
        }
        return locLinks;
    }

    public boolean hasRailcard(String railcardCode) {
        if (this.railcards != null) {
            for (String eachRailcard : this.railcards) {
                if (!eachRailcard.equals(railcardCode)) continue;
                return true;
            }
        }
        return false;
    }

    public clsPTEZones getPTEZones() {
        if (this.zoneInd == null || this.zoneInd.isEmpty()) {
            return null;
        }
        clsPTEZones PTEZones = new clsPTEZones();
        PTEZones.zones = this.zoneInd;
        if (this.boundaryZoneNo != null) {
            PTEZones.zones = PTEZones.zones + this.boundaryZoneNo;
            PTEZones.boundaryLoc = true;
        }
        return PTEZones;
    }

    public String toString() {
        StringBuffer sData = new StringBuffer();
        String PREFIX = "\n                    ";
        sData.append("\n      clsLocation:");
        sData.append("\n                    UIC7=" + this.UIC7 + "\t NLCCode=" + this.NLCCode + "\t CRSCode=" + this.CRSCode + "\t groupCode=" + this.groupCode + "\t countyCode=" + this.countyCode + "\t zoneCode=" + this.zoneCode + "\t zoneInd=" + this.zoneInd + "\t PTECode=" + this.PTECode + "\t isAnENRGStation=" + this.isAnENRGStation + "\n                    " + "description=" + this.description + "\t startDate=" + this.startDate + "\t endDate=" + this.endDate + "\n                    " + "locationLinks=" + this.locationLinks + "\n                    " + "specialFacilities=" + this.specialFacilities + "\n                    " + "railcards=" + this.railcards + "\n                    " + "fareZones=" + this.fareZones + "\n                    " + "PTEZones=" + this.PTEZones + "\n                    " + "THOLocation=" + this.THOLocation + "\n                    " + "boundaryZoneNo=" + this.boundaryZoneNo + "\n                    " + "hierarchy=" + this.hierarchy);
        return sData.toString();
    }

    public boolean equals(Object locObj) {
        clsLocation loc;
        return locObj instanceof clsLocation && (loc = (clsLocation)locObj) != null && loc.CRSCode.equals(this.CRSCode) && loc.UIC7.equals(this.UIC7) && loc.NLCCode.equals(this.NLCCode);
    }
}

