/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SaleGUI;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.BasketComment;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SupportBL.DataConvert;
import java.util.ArrayList;

public class BasketListAdaptor
extends ArrayAdapter<BasketSupport> {
    private final Activity context;
    private final ArrayList<BasketSupport> faresList;
    private final AppContext bb;

    public BasketListAdaptor(Activity context, ArrayList<BasketSupport> list, AppContext bb) {
        super((Context)context, R.layout.basket_entry, list);
        this.context = context;
        this.faresList = list;
        this.bb = bb;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View rowView = convertView;
        LayoutInflater inflater = this.context.getLayoutInflater();
        if (rowView == null) {
            rowView = inflater.inflate(R.layout.basket_entry, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.lay_entry = (LinearLayout)rowView.findViewById(R.id.lay_entry);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        rowView.setBackgroundColor(0);
        BasketSupport bs = this.faresList.get(position);
        if (bs.itemType == BasketSupport.ItemType.FARE) {
            this.displayFare(holder, inflater, rowView, bs);
        } else if (bs.itemType == BasketSupport.ItemType.RETAIL_ITEM) {
            this.displayRetailItem(holder, inflater, rowView, bs);
        } else if (bs.itemType == BasketSupport.ItemType.COMMENT) {
            this.displayComment(holder, inflater, rowView, bs);
        } else if (bs.itemType == BasketSupport.ItemType.TENDER) {
            this.displayTender(holder, inflater, rowView, bs);
        }
        return rowView;
    }

    private void displayTender(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.tender_entry, null));
        TextView txtTender = (TextView)rowView.findViewById(R.id.txtTender);
        TextView txtAmount = (TextView)rowView.findViewById(R.id.txtAmount);
        Tender s = bs.tender;
        if (s.tenderType == Tender.TenderType.CASH) {
            txtTender.setText((CharSequence)"Cash tendered");
        } else if (s.tenderType == Tender.TenderType.CHANGE) {
            txtTender.setText((CharSequence)"Change given");
        } else if (s.tenderType == Tender.TenderType.CARD) {
            txtTender.setText((CharSequence)"Card tendered");
        }
        double intCost = s.tenderValue / 100.0;
        txtAmount.setText((CharSequence)String.format("\u00a3%.2f", intCost));
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.context.getResources().getColor(Color, TH);
        }
        return this.context.getResources().getColor(Color);
    }

    private void displayRetailItem(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport rs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.retailitem_entry, null));
        TextView txtDomain = (TextView)rowView.findViewById(R.id.txtDomain);
        TextView txtComment = (TextView)rowView.findViewById(R.id.txtComment);
        TextView txtDirection = (TextView)rowView.findViewById(R.id.txtDirection);
        TextView txtTime = (TextView)rowView.findViewById(R.id.txtTime);
        txtDomain.setPadding(0, 0, 0, 0);
        txtDomain.setText((CharSequence)rs.retail.Description);
        txtComment.setPadding(80, 0, 0, 0);
        txtComment.setText((CharSequence)rs.retail.PLU);
        txtDirection.setText((CharSequence)"");
        txtTime.setText((CharSequence)("\u00a3" + DataConvert.doubleToDisplayFormat(rs.retail.Price)));
    }

    private void displayComment(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.basket_comment_entry, null));
        TextView txtComment = (TextView)rowView.findViewById(R.id.txtComment);
        TextView txtAmount = (TextView)rowView.findViewById(R.id.txtAmount);
        BasketComment s = bs.comment;
        txtComment.setText((CharSequence)s.CommentText);
        double intCost = s.CommentValue / 100.0;
        txtAmount.setText((CharSequence)String.format("\u00a3%.2f", intCost));
    }

    private void displayFare(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.ticket_entry, null));
        TextView txtClass = (TextView)rowView.findViewById(R.id.txtClass);
        TextView txtTicketCode = (TextView)rowView.findViewById(R.id.txtTicketCode);
        TextView txtTicketDesc = (TextView)rowView.findViewById(R.id.txtTicketDesc);
        TextView txtCost = (TextView)rowView.findViewById(R.id.txtCost);
        TextView txtOrigin = (TextView)rowView.findViewById(R.id.txtOrigin);
        TextView txtDestination = (TextView)rowView.findViewById(R.id.txtDestination);
        TextView txtFlowOwner = (TextView)rowView.findViewById(R.id.txtFlowOwner);
        TextView txtRoute = (TextView)rowView.findViewById(R.id.txtRoute);
        TextView txtRestrictionCode = (TextView)rowView.findViewById(R.id.txtRestrictionCode);
        LinearLayout layReasons = (LinearLayout)rowView.findViewById(R.id.layReasons);
        TNFare s = bs.ticket;
        if (s.getFa_FareClass() == 1) {
            txtClass.setText((CharSequence)"1st");
            txtClass.setTextColor(this.JMgetColor(R.color.fj_blue_3, this.context.getTheme()));
        } else {
            txtClass.setText((CharSequence)"STD");
            txtClass.setTextColor(this.JMgetColor(R.color.fj_black_0, this.context.getTheme()));
        }
        txtTicketCode.setText((CharSequence)s.getFa_TicketTypeCode());
        String txtTicketCodeDesc = s.getFa_TicketTypeCode();
        if (FareManager.ticketCodes.containsKey(txtTicketCodeDesc)) {
            TicketDetails tkt = FareManager.ticketCodes.getValue(txtTicketCodeDesc);
            txtTicketDesc.setText((CharSequence)tkt.getTd_TicketTypeDesc());
        } else {
            txtTicketDesc.setText((CharSequence)(txtTicketCode + "????"));
        }
        double intCost = (double)s.getFa_TotalFareS() / 100.0;
        txtCost.setText((CharSequence)String.format("\u00a3%.2f", intCost));
        String txtNLCCode = s.getFa_FareOriginLocation();
        Location loc = Location.getLocationByNLC(txtNLCCode);
        String txtLoc = loc != null ? loc.getDescription().trim() : "";
        if (txtLoc.length() > 0) {
            txtOrigin.setText((CharSequence)txtLoc);
        } else {
            txtOrigin.setText((CharSequence)txtNLCCode);
        }
        txtNLCCode = s.getFa_FareDestinationLocation();
        loc = Location.getLocationByNLC(txtNLCCode);
        txtLoc = loc != null ? loc.getDescription().trim() : "";
        if (txtLoc.length() > 0) {
            txtDestination.setText((CharSequence)txtLoc);
        } else {
            txtDestination.setText((CharSequence)txtNLCCode);
        }
        txtFlowOwner.setText((CharSequence)s.getFa_FlowOwner());
        txtRoute.setText((CharSequence)s.getFa_RouteDescription());
        txtRestrictionCode.setText((CharSequence)s.getFa_RestrictionCode());
        String txtNoSaleReason = s.getFa_NoSaleReason();
        if (txtNoSaleReason.length() == 0) {
            layReasons.removeAllViews();
        } else {
            layReasons.removeAllViews();
            layReasons.addView(inflater.inflate(R.layout.ticket_summary_reason, null));
            TextView txtNotes = (TextView)rowView.findViewById(R.id.txtNotes);
            txtNotes.setText((CharSequence)s.getFa_NoSaleReason());
        }
    }

    static class ViewHolder {
        public LinearLayout lay_entry;

        ViewHolder() {
        }
    }
}

