/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SaleGUI;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.DevicesBL.IngenicoCommon;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SupportBL.DataConvert;
import com.ingenico.pclservice.IPclService;
import com.ingenico.pclservice.IPclServiceCallback;
import com.ingenico.pclservice.TransactionIn;
import com.ingenico.pclservice.TransactionOut;

public class TenderCard
extends IngenicoCommon {
    private Context activityContext;
    private int amountDue = 0;
    private int amountTendered = 0;
    private boolean canRetry = false;
    private boolean payInProgress = false;
    private IPclServiceCallback mCallback = new IPclServiceCallback.Stub(){

        @Override
        public void shouldFeedPaper(int lines) {
            Log.e((String)"INGENICO", (String)("shouldFeedPaper " + lines));
        }

        @Override
        public void shouldCutPaper() throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldCutPaper ");
        }

        @Override
        public void shouldPrintText(String text, byte font, byte justification, byte xfactor, byte yfactor, byte underline, byte bold) throws RemoteException {
            Log.e((String)"INGENICO", (String)("shouldPrintText " + text));
        }

        @Override
        public void shouldPrintImage(Bitmap image, byte justification) throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldPrintImage ");
        }

        @Override
        public void shouldDoSignatureCapture(int pos_x, int pos_y, int width, int height, int timeout) throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldDoSignatureCapture ");
        }

        @Override
        public void signatureTimeoutExceeded() throws RemoteException {
            Log.e((String)"INGENICO", (String)"signatureTimeoutExceeded ");
        }

        @Override
        public void shouldAddSignature() throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldAddSignature ");
        }

        @Override
        public int shouldStartReceipt(byte type) throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldStartReceipt ");
            return 0;
        }

        @Override
        public int shouldEndReceipt() throws RemoteException {
            Log.e((String)"INGENICO", (String)"shouldEndReceipt ");
            return 0;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_tendercard);
        TenderCard context = this;
        final AppContext bb = (AppContext)this.getApplicationContext();
        bb.basket.refreshBasket(bb);
        this.amountDue = bb.basket.balanceDue;
        this.setTitle(" Tender Card");
        this.activityContext = this;
        this.mReleaseService = 1;
        PclObject data = (PclObject)this.getLastNonConfigurationInstance();
        if (data == null || data.service == null || data.serviceConnection == null) {
            Log.d((String)"INGENICO", (String)"onCreate: Init service");
            this.initService();
        } else {
            Log.d((String)"INGENICO", (String)"onCreate: Service already initialized");
            this.mServiceConnection = data.serviceConnection;
            this.mPclService = data.service;
            this.mBound = true;
        }
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        txtPED.setText((CharSequence)"Checking PED");
        LinearLayout layAmountDue = (LinearLayout)this.findViewById(R.id.layAmountDue);
        layAmountDue.setOnClickListener(new View.OnClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onClick(View view) {
                LayoutInflater layoutInflater = LayoutInflater.from((Context)this.val$context);
                View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);
                AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.val$context);
                alertDialogBuilder.setView(promptView);
                final EditText input = (EditText)promptView.findViewById(R.id.userInput);
                alertDialogBuilder.setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        String txtAmount = String.valueOf(input.getText());
                        TenderCard.this.amountDue = TenderCard.this.currencyStringInt(txtAmount);
                        TenderCard.this.refreshData();
                        TenderCard.this.makePayment(TenderCard.this.amountDue);
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog alertD = alertDialogBuilder.create();
                alertD.show();
                alertD.getWindow().clearFlags(131080);
                alertD.getWindow().setSoftInputMode(5);
            }
        });
        this.refreshData();
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        cmdDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tender card = new Tender();
                card.tenderValue = TenderCard.this.amountTendered;
                card.tenderType = Tender.TenderType.CARD;
                bb.basket.addTender(card, TenderCard.this.amountTendered);
                bb.basket.refreshBasket(bb);
                Intent returnIntent = new Intent();
                returnIntent.putExtra("result", "Done");
                TenderCard.this.setResult(-1, returnIntent);
                TenderCard.this.finish();
            }
        });
        Button cmdRetry = (Button)this.findViewById(R.id.cmdRetry);
        cmdRetry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TenderCard.this.makePayment(TenderCard.this.amountDue);
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void refreshData() {
        TextView txtAmountDue = (TextView)this.findViewById(R.id.txtAmountDue);
        TextView txtAmountTendered = (TextView)this.findViewById(R.id.txtAmountTendered);
        double intCost = (double)this.amountDue / 100.0;
        txtAmountDue.setText((CharSequence)String.format("\u00a3%.2f", intCost));
        if (this.amountTendered != 0) {
            intCost = (double)this.amountTendered / 100.0;
            txtAmountTendered.setText((CharSequence)String.format("\u00a3%.2f", intCost));
        } else {
            txtAmountTendered.setText((CharSequence)"");
        }
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        if (this.amountTendered > 0) {
            cmdDone.setEnabled(true);
            cmdDone.setBackgroundColor(this.getResources().getColor(R.color.button_background));
        } else {
            cmdDone.setEnabled(false);
            cmdDone.setBackgroundColor(this.getResources().getColor(R.color.button_background_disabled));
        }
        Button cmdRetry = (Button)this.findViewById(R.id.cmdRetry);
        if (this.canRetry || this.payInProgress) {
            cmdRetry.setEnabled(true);
            cmdRetry.setBackgroundColor(this.getResources().getColor(R.color.button_background));
        } else {
            cmdRetry.setEnabled(false);
            cmdRetry.setBackgroundColor(this.getResources().getColor(R.color.button_background_disabled));
        }
    }

    private int currencyStringInt(String txtIn) {
        String txtStriped = txtIn.replace("\ufffd", "").trim();
        if (txtStriped.length() == 0) {
            return 0;
        }
        double amount = Double.valueOf(txtStriped);
        int adjustedAmount = (int)(amount * 100.0);
        return adjustedAmount;
    }

    @Override
    public void onStateChanged(String state) {
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        if (state.equals("CONNECTED")) {
            txtPED.setText((CharSequence)"Connected");
            txtPED.setBackgroundColor(-16711936);
            txtPED.setTextColor(-16777216);
            if (this.amountDue != 0) {
                this.makePayment(this.amountDue);
            }
        } else {
            txtPED.setText((CharSequence)"Not connected");
            txtPED.setBackgroundColor(-65536);
            txtPED.setTextColor(-16777216);
        }
    }

    @Override
    public void onPclServiceConnected() {
        Log.d((String)"INGENICO", (String)"onPclServiceConnected");
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        if (this.isCompanionConnected()) {
            txtPED.setText((CharSequence)"Connected companion");
            txtPED.setBackgroundColor(-16711936);
            txtPED.setTextColor(-16777216);
            if (this.amountDue != 0) {
                this.makePayment(this.amountDue);
            }
        } else {
            txtPED.setText((CharSequence)"Ped not connected");
            txtPED.setBackgroundColor(-65536);
            txtPED.setTextColor(-16777216);
        }
    }

    @Override
    public void onBarCodeReceived(String barCodeValue) {
        TextView txtCCSTPrinter = (TextView)this.findViewById(R.id.txtCCSTPrinter);
        txtCCSTPrinter.setText((CharSequence)barCodeValue);
        Log.d((String)"INGENICO", (String)"Ignored barcode");
    }

    private boolean openBarcode(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.openBarcode(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        } else {
            Log.d((String)"INGENICO", (String)"openBarcode: mPclService is null");
        }
        return ret;
    }

    private boolean closeBarcode(byte[] result) {
        boolean ret = false;
        if (this.mPclService != null) {
            try {
                ret = this.mPclService.closeBarcode(result);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    private void makePayment(int requestAmountPence) {
        this.payInProgress = true;
        TransactionIn transIn = new TransactionIn();
        TransactionOut transOut = new TransactionOut();
        try {
            this.mPclService.registerCallback(this.mCallback, false);
            Log.d((String)"INGENICO", (String)"registerCallback");
        }
        catch (RemoteException e) {
            Log.e((String)"INGENICO", (String)"Register failed");
        }
        String amount = Integer.toString(requestAmountPence);
        transIn.setAmount(amount);
        transIn.setCurrencyCode("978");
        transIn.setOperation("C");
        transIn.setTermNum("58");
        TextView txtPED = (TextView)this.findViewById(R.id.txtPED);
        txtPED.setText((CharSequence)"Hand payment terminal to customer \nTransaction in progress");
        new DoTransactionTask(transIn, transOut).execute(new Void[0]);
    }

    class DoTransactionTask
    extends AsyncTask<Void, Void, Boolean> {
        private TransactionIn transIn;
        private TransactionOut transOut;

        public DoTransactionTask(TransactionIn transIn, TransactionOut transOut) {
            Log.d((String)"INGENICO", (String)String.format("DoTransactionTask CONSTRUCT", new Object[0]));
            this.transIn = transIn;
            this.transOut = transOut;
        }

        protected Boolean doInBackground(Void ... tmp) {
            Boolean bRet = TenderCard.this.doTransaction(this.transIn, this.transOut);
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)"INGENICO", (String)String.format("DoTransactionTask onPostExecute", new Object[0]));
            TenderCard.this.payInProgress = false;
            TextView txtPED = (TextView)TenderCard.this.findViewById(R.id.txtPED);
            txtPED.setText((CharSequence)("PED response " + this.transOut.getC3Error()));
            if (this.transOut.getC3Error().equals("0000")) {
                String receipt = "";
                TenderCard.this.amountTendered = DataConvert.stringToInt(this.transOut.getAmount());
                txtPED.setText((CharSequence)("Success " + TenderCard.this.amountTendered));
                TenderCard.this.canRetry = false;
                TenderCard.this.refreshData();
            } else {
                txtPED.setText((CharSequence)("Failed " + this.transOut.getC3Error()));
                Toast.makeText((Context)TenderCard.this.getBaseContext(), (CharSequence)TenderCard.this.getString(R.string.str_failed), (int)1).show();
                TenderCard.this.canRetry = true;
                TenderCard.this.refreshData();
            }
        }
    }

    class CloseBarcodeTask
    extends AsyncTask<Void, Void, Boolean> {
        private byte[] mResult;

        CloseBarcodeTask(byte[] result) {
            this.mResult = result;
        }

        protected Boolean doInBackground(Void ... dummy) {
            Boolean bRet = false;
            bRet = TenderCard.this.closeBarcode(this.mResult);
            Log.d((String)"INGENICO", (String)String.format("closeBarcode bRet=%s mResult=%d", Boolean.toString(bRet), this.mResult[0]));
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "N/A";
            TextView txtPED = (TextView)TenderCard.this.findViewById(R.id.txtPED);
            txtPED.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                switch (this.mResult[0]) {
                    case 0: {
                        strResult = "OK";
                        txtPED.setText((CharSequence)strResult);
                        break;
                    }
                    default: {
                        strResult = "Failed (" + this.mResult[0] + ")";
                        txtPED.setText((CharSequence)strResult);
                        break;
                    }
                }
            } else {
                txtPED.setText((CharSequence)"Failed ");
            }
        }
    }

    class OpenBarcodeTask
    extends AsyncTask<Void, Void, Boolean> {
        private byte[] mResult;

        OpenBarcodeTask(byte[] result) {
            this.mResult = result;
        }

        protected Boolean doInBackground(Void ... dummy) {
            Boolean bRet = false;
            bRet = TenderCard.this.openBarcode(this.mResult);
            Log.d((String)"INGENICO", (String)String.format("openBarcode bRet=%s mResult=%d", Boolean.toString(bRet), this.mResult[0]));
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "";
            TextView txtCCSTPrinter = (TextView)TenderCard.this.findViewById(R.id.txtCCSTPrinter);
            txtCCSTPrinter.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                switch (this.mResult[0]) {
                    case 0: {
                        strResult = "Barcode scanner ready";
                        break;
                    }
                    default: {
                        strResult = "Failed (" + this.mResult[0] + ")";
                        break;
                    }
                }
            } else {
                strResult = "Barcode scanner on";
            }
            txtCCSTPrinter.setText((CharSequence)strResult);
        }
    }

    class GetTermInfoTask
    extends AsyncTask<Void, Void, Boolean> {
        GetTermInfoTask() {
        }

        protected Boolean doInBackground(Void ... tmp) {
            Boolean bRet = TenderCard.this.getTermInfo();
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
            String strResult = "PED not connected";
            TextView txtPED = (TextView)TenderCard.this.findViewById(R.id.txtPED);
            txtPED.setText((CharSequence)Boolean.toString(result));
            if (result.booleanValue()) {
                strResult = String.format("SN: %08x PN:%08x", TenderCard.this.SN, TenderCard.this.PN);
                txtPED.setBackgroundColor(-16711936);
                txtPED.setTextColor(-16777216);
            } else {
                txtPED.setBackgroundColor(-65536);
                txtPED.setTextColor(-16777216);
            }
            txtPED.setText((CharSequence)strResult);
        }
    }

    static class PclObject {
        IngenicoCommon.PclServiceConnection serviceConnection;
        IPclService service;

        PclObject() {
        }
    }
}

